/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.caesium.cron.rule;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.zone.ZoneOffsetTransition;
import java.util.Date;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeTemplate
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(DateTimeTemplate.class);
    private static final int[] MAX_DAY_BY_MONTH = new int[]{-1, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private final ZoneId zone;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;

    public DateTimeTemplate(ZonedDateTime dateTime) {
        this.zone = ZoneId.of(dateTime.getZone().getId());
        this.year = dateTime.getYear();
        this.month = dateTime.getMonthValue();
        this.day = dateTime.getDayOfMonth();
        this.hour = dateTime.getHour();
        this.minute = dateTime.getMinute();
        this.second = dateTime.getSecond();
    }

    public DateTimeTemplate(Date date, ZoneId zone) {
        this(date.toInstant().atZone(zone));
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public ZoneId getZoneId() {
        return this.zone;
    }

    public LocalDate toFirstDayOfMonth() {
        return LocalDate.of(this.year, this.month, 1);
    }

    @Nullable
    public ZonedDateTime toZonedDateTime() {
        if (!this.isPlausible()) {
            return null;
        }
        try {
            LocalDateTime localDateTime = LocalDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second);
            ZoneOffsetTransition transition = this.zone.getRules().getTransition(localDateTime);
            if (transition == null || !transition.isGap()) {
                return ZonedDateTime.of(localDateTime, this.zone).withLaterOffsetAtOverlap();
            }
            return null;
        }
        catch (DateTimeException dte) {
            LOG.debug("Invalid date: {}", (Object)this, (Object)dte);
            return null;
        }
    }

    private boolean isPlausible() {
        if (this.month < 1 || this.month > 12 || this.day > MAX_DAY_BY_MONTH[this.month]) {
            return false;
        }
        return this.day != 29 || this.month != 2 || (this.year & 3) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64).append(this.year);
        DateTimeTemplate.append2(sb, '/', this.month);
        DateTimeTemplate.append2(sb, '/', this.day);
        DateTimeTemplate.append2(sb, ' ', this.hour);
        DateTimeTemplate.append2(sb, ':', this.minute);
        DateTimeTemplate.append2(sb, ':', this.second);
        return sb.append(" (").append(this.zone).append(')').toString();
    }

    private static void append2(StringBuilder sb, char delimiter, int value) {
        sb.append(delimiter);
        if (value < 10) {
            sb.append('0');
        }
        sb.append(value);
    }

    public static enum Field {
        YEAR(1970, 2999){

            @Override
            public int get(DateTimeTemplate dateTime) {
                return dateTime.getYear();
            }

            @Override
            public void set(DateTimeTemplate dateTime, int value) {
                dateTime.setYear(value);
            }
        }
        ,
        MONTH(1, 12){

            @Override
            public int get(DateTimeTemplate dateTime) {
                return dateTime.getMonth();
            }

            @Override
            public void set(DateTimeTemplate dateTime, int value) {
                dateTime.setMonth(value);
            }
        }
        ,
        DAY(1, 31){

            @Override
            public int get(DateTimeTemplate dateTime) {
                return dateTime.getDay();
            }

            @Override
            public void set(DateTimeTemplate dateTime, int value) {
                dateTime.setDay(value);
            }
        }
        ,
        HOUR(0, 23){

            @Override
            public int get(DateTimeTemplate dateTime) {
                return dateTime.getHour();
            }

            @Override
            public void set(DateTimeTemplate dateTime, int value) {
                dateTime.setHour(value);
            }
        }
        ,
        MINUTE(0, 59){

            @Override
            public int get(DateTimeTemplate dateTime) {
                return dateTime.getMinute();
            }

            @Override
            public void set(DateTimeTemplate dateTime, int value) {
                dateTime.setMinute(value);
            }
        }
        ,
        SECOND(0, 59){

            @Override
            public int get(DateTimeTemplate dateTime) {
                return dateTime.getSecond();
            }

            @Override
            public void set(DateTimeTemplate dateTime, int value) {
                dateTime.setSecond(value);
            }
        };

        private final int minimumValue;
        private final int maximumValue;

        private Field(int minimumValue, int maximumValue) {
            this.minimumValue = minimumValue;
            this.maximumValue = maximumValue;
        }

        public abstract int get(DateTimeTemplate var1);

        public abstract void set(DateTimeTemplate var1, int var2);

        public int getMinimumValue() {
            return this.minimumValue;
        }

        public int getMaximumValue() {
            return this.maximumValue;
        }
    }
}

