/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.licensebanner.provider;

import com.atlassian.confluence.plugins.licensebanner.provider.LicenseDetailsModel;
import com.atlassian.confluence.plugins.licensebanner.support.LicenseBannerService;
import com.atlassian.confluence.plugins.licensebanner.support.LicenseDetails;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;

public class LicenseDetailsProvider
implements WebResourceDataProvider {
    private final UserManager userManager;
    private final LicenseBannerService licenseBannerService;
    private final ObjectMapper objectMapper;

    public LicenseDetailsProvider(@ComponentImport UserManager userManager, LicenseBannerService licenseBannerService, @ComponentImport ObjectMapperProvider objectMapperProvider) {
        this.userManager = userManager;
        this.licenseBannerService = licenseBannerService;
        this.objectMapper = objectMapperProvider.getObjectMapper();
    }

    public Jsonable get() {
        LicenseDetailsModel licenseDetailsModel;
        UserKey remoteUserKey = this.userManager.getRemoteUserKey();
        if (remoteUserKey == null || !this.userManager.isSystemAdmin(remoteUserKey)) {
            licenseDetailsModel = new LicenseDetailsModel();
        } else {
            LicenseDetails details = this.licenseBannerService.retrieveLicenseDetails(remoteUserKey);
            licenseDetailsModel = new LicenseDetailsModel(details);
        }
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                LicenseDetailsProvider.this.objectMapper.writeValue(writer, (Object)licenseDetailsModel);
            }
        };
    }
}

