/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.licensebanner.rest;

import com.atlassian.confluence.plugins.licensebanner.support.LicenseBannerService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="/reminder")
@SystemAdminOnly
public class LicenseReminderResource {
    private final UserManager userManager;
    private final LicenseBannerService licenseBannerService;

    @Inject
    public LicenseReminderResource(@ComponentImport UserManager userManager, LicenseBannerService licenseBannerService) {
        this.userManager = userManager;
        this.licenseBannerService = licenseBannerService;
    }

    @POST
    @Path(value="later")
    public void remindMeLater() {
        UserKey remoteUserKey = this.userManager.getRemoteUserKey();
        if (remoteUserKey != null && this.userManager.isSystemAdmin(remoteUserKey)) {
            this.licenseBannerService.remindLater(remoteUserKey);
        }
    }

    @POST
    @Path(value="never")
    public void remindMeNever() {
        UserKey remoteUserKey = this.userManager.getRemoteUserKey();
        if (remoteUserKey != null && this.userManager.isSystemAdmin(remoteUserKey)) {
            this.licenseBannerService.remindNever(remoteUserKey);
        }
    }
}

