/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.persistence.schema.hibernate;

import com.atlassian.confluence.core.persistence.schema.api.SchemaComparison;
import com.atlassian.confluence.core.persistence.schema.api.SchemaComparisonService;
import com.atlassian.confluence.core.persistence.schema.api.SchemaInformationService;
import com.atlassian.confluence.core.persistence.schema.hibernate.HibernateSchemaComparator;
import com.atlassian.confluence.impl.core.persistence.hibernate.HibernateMetadataSource;
import com.google.common.base.Stopwatch;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.hibernate.Session;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateSchemaComparisonService
implements SchemaComparisonService {
    private static final Logger log = LoggerFactory.getLogger(HibernateSchemaComparisonService.class);
    private final SessionFactoryImplementor sessionFactory;
    private final HibernateMetadataSource metadataSource;
    private final SchemaInformationService dbSchemaInformationService;

    public HibernateSchemaComparisonService(SessionFactoryImplementor sessionFactory, HibernateMetadataSource metadataSource, SchemaInformationService dbSchemaInformationService) {
        this.sessionFactory = Objects.requireNonNull(sessionFactory);
        this.metadataSource = Objects.requireNonNull(metadataSource);
        this.dbSchemaInformationService = Objects.requireNonNull(dbSchemaInformationService);
    }

    @Override
    public SchemaComparison compareExpectedWithActualSchema() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            SchemaComparison schemaComparison;
            block9: {
                Session session = this.sessionFactory.openSession();
                try {
                    log.debug("Opening Hibernate session for comparison took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
                    stopwatch.reset();
                    stopwatch.start();
                    HibernateSchemaComparator comparator = new HibernateSchemaComparator((Mapping)this.sessionFactory, this.metadataSource, this.dbSchemaInformationService);
                    schemaComparison = comparator.compareSchema();
                    if (session == null) break block9;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return schemaComparison;
        }
        finally {
            log.debug("Generating schema comparison took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }
}

