/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.projectcreate.producer.filters;

import com.atlassian.annotations.security.UnrestrictedAccess;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class RestUrlServletFilter
implements Filter {
    static final String REST_BASE_INIT_PARAM = "rest-base";
    static final String DEFAULT_VERSION_INIT_PARAM = "rest-default-version";
    private final Logger logger = LoggerFactory.getLogger(RestUrlServletFilter.class);
    private String restBase;
    private String defaultVersion;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.restBase = filterConfig.getInitParameter(REST_BASE_INIT_PARAM);
        this.defaultVersion = filterConfig.getInitParameter(DEFAULT_VERSION_INIT_PARAM);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String requestUrl = httpRequest.getRequestURI();
            Object restUrl = requestUrl.substring(httpRequest.getContextPath().length() + this.restBase.length());
            if (((String)restUrl).matches("^/[\\d.]{1,5}($|/.*)")) {
                if (!((String)restUrl).endsWith("/")) {
                    String rewriteTarget = this.restBase + (String)restUrl + "/";
                    this.logger.debug("Rewriting request to " + rewriteTarget);
                    request.getRequestDispatcher(rewriteTarget).forward(request, response);
                    return;
                }
            } else {
                if (!((String)restUrl).endsWith("/")) {
                    restUrl = (String)restUrl + "/";
                }
                String rewriteTarget = this.restBase + "/" + this.defaultVersion + (String)restUrl;
                this.logger.debug("Rewriting request to " + rewriteTarget);
                request.getRequestDispatcher(rewriteTarget).forward(request, response);
                return;
            }
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

