/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign.decode;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.domassign.decode.BorderColorRepeater;
import cz.vutbr.web.domassign.decode.BorderStyleRepeater;
import cz.vutbr.web.domassign.decode.BorderWidthRepeater;
import cz.vutbr.web.domassign.decode.Repeater;
import cz.vutbr.web.domassign.decode.Variator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BorderVariator
extends Variator {
    public static final int WIDTH = 0;
    public static final int STYLE = 1;
    public static final int COLOR = 2;
    private List<Repeater> repeaters;

    public BorderVariator() {
        super(3);
        this.types.add(CSSProperty.BorderWidth.class);
        this.types.add(CSSProperty.BorderStyle.class);
        this.types.add(CSSProperty.BorderColor.class);
        this.repeaters = new ArrayList<Repeater>(this.variants);
        this.repeaters.add(new BorderWidthRepeater());
        this.repeaters.add(new BorderStyleRepeater());
        this.repeaters.add(new BorderColorRepeater());
    }

    @Override
    protected boolean variant(int variant, Variator.IntegerRef iteration, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        int i = iteration.get();
        Term term = (Term)this.terms.get(i);
        switch (variant) {
            case 0: {
                Repeater r = this.repeaters.get(0);
                r.assignTerms(term, term, term, term);
                return r.repeat(properties, values);
            }
            case 1: {
                Repeater r = this.repeaters.get(1);
                r.assignTerms(term, term, term, term);
                return r.repeat(properties, values);
            }
            case 2: {
                Repeater r = this.repeaters.get(2);
                r.assignTerms(term, term, term, term);
                return r.repeat(properties, values);
            }
        }
        return false;
    }

    @Override
    protected boolean checkInherit(int variant, Term<?> term, Map<String, CSSProperty> properties) {
        if (!(term instanceof TermIdent) || !"INHERIT".equalsIgnoreCase((String)((TermIdent)term).getValue())) {
            return false;
        }
        if (variant == -1) {
            for (int i = 0; i < this.variants; ++i) {
                Repeater r = this.repeaters.get(i);
                r.assignTerms(term, term, term, term);
                r.repeat(properties, null);
            }
            return true;
        }
        Repeater r = this.repeaters.get(variant);
        r.assignTerms(term, term, term, term);
        r.repeat(properties, null);
        return true;
    }

    @Override
    public void assignDefaults(Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        for (Repeater r : this.repeaters) {
            r.assignDefaults(properties, values);
        }
    }
}

