/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.prettyurls.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.prettyurls.filter.PrettyUrlsCommonFilter;
import com.atlassian.prettyurls.internal.route.UrlRouter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class PrettyUrlsCombinedMatchDispatcherFilter
extends PrettyUrlsCommonFilter {
    private static final Logger log = LoggerFactory.getLogger(PrettyUrlsCombinedMatchDispatcherFilter.class);
    private final UrlRouter urlRouter;

    public PrettyUrlsCombinedMatchDispatcherFilter(UrlRouter urlRouter) {
        this.urlRouter = urlRouter;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String fromURI = httpServletRequest.getRequestURI();
        UrlRouter.Result result = this.urlRouter.route(httpServletRequest, this.location);
        if (result.isRouted()) {
            String toURI = result.toURI();
            if (log.isDebugEnabled()) {
                log.debug("Will route from {} ==> {}", (Object)fromURI, (Object)toURI);
            }
            this.setInformationRequestVariables(httpServletRequest, fromURI, toURI);
            httpServletRequest.getRequestDispatcher(toURI).forward(servletRequest, servletResponse);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

