/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.prettyurls.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.prettyurls.filter.PrettyUrlsCommonFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class PrettyUrlsDispatcherFilter
extends PrettyUrlsCommonFilter {
    private static final Logger log = LoggerFactory.getLogger(PrettyUrlsDispatcherFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        if (httpServletRequest.getAttribute("pretty.urls.performRoute") != null) {
            String fromURI = (String)httpServletRequest.getAttribute("pretty.urls.fromURI");
            String toURI = (String)httpServletRequest.getAttribute("pretty.urls.toURI");
            httpServletRequest.removeAttribute("pretty.urls.performRoute");
            if (log.isDebugEnabled()) {
                log.debug("Routing {} ==> {}", (Object)fromURI, (Object)toURI);
            }
            httpServletRequest.getRequestDispatcher(toURI).forward(servletRequest, servletResponse);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

