/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.prettyurls.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.prettyurls.filter.PrettyUrlsCommonFilter;
import com.atlassian.prettyurls.internal.util.UrlUtils;
import com.atlassian.prettyurls.module.SiteMeshModuleDescriptor;
import jakarta.annotation.Nullable;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class PrettyUrlsSiteMeshFilter
extends PrettyUrlsCommonFilter {
    private static final Logger log = LoggerFactory.getLogger(PrettyUrlsSiteMeshFilter.class);
    private final Filter siteMeshFilterDelegate;
    private final PluginAccessor pluginAccessor;

    public PrettyUrlsSiteMeshFilter(@ComponentImport PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.siteMeshFilterDelegate = PrettyUrlsSiteMeshFilter.loadFilter("com.opensymphony.sitemesh.webapp.SiteMeshFilter");
    }

    @Nullable
    static Filter loadFilter(String filterClassName) {
        try {
            return Class.forName(filterClassName).asSubclass(Filter.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            log.warn("Class [{}] is not found. If you see this in jira it means it's ERROR.", (Object)filterClassName);
            return null;
        }
        catch (ClassCastException e) {
            log.warn("Class [{}] is not of type [{}]", (Object)filterClassName, (Object)Filter.class.getName());
            return null;
        }
        catch (ReflectiveOperationException e) {
            log.warn("Failed to instantiate filter of class [{}]", (Object)filterClassName);
            return null;
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.siteMeshFilterDelegate != null) {
            this.siteMeshFilterDelegate.init(filterConfig);
        }
    }

    @Override
    public void destroy() {
        if (this.siteMeshFilterDelegate != null) {
            this.siteMeshFilterDelegate.destroy();
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.siteMeshFilterDelegate == null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpServletRequest = this.preventDoubleInvocation(servletRequest, servletResponse, filterChain);
        if (httpServletRequest == null) {
            return;
        }
        if (this.needsSiteMeshDecoration(httpServletRequest)) {
            this.siteMeshFilterDelegate.doFilter(servletRequest, servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private boolean needsSiteMeshDecoration(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getAttribute("com.opensymphony.sitemesh.APPLIED_ONCE") != null) {
            return false;
        }
        String requestURI = this.makeRequestURI(httpServletRequest);
        List siteMeshModules = this.pluginAccessor.getEnabledModuleDescriptorsByClass(SiteMeshModuleDescriptor.class);
        for (SiteMeshModuleDescriptor module : siteMeshModules) {
            if (!requestURI.startsWith(module.getPath())) continue;
            return true;
        }
        return false;
    }

    private String makeRequestURI(HttpServletRequest httpServletRequest) {
        String context;
        String requestURI = httpServletRequest.getRequestURI();
        if (requestURI.startsWith(context = httpServletRequest.getContextPath())) {
            requestURI = requestURI.substring(context.length());
        }
        return UrlUtils.startWithSlash(requestURI);
    }
}

