/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.external;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.webhooks.internal.dao.ao.v1.ExternalMigrationTaskInvokerGuard;
import com.atlassian.webhooks.internal.dao.ao.v1.WebhookV1MigrateService;
import com.atlassian.webhooks.migration.WebhookDTO;
import com.atlassian.webhooks.migration.WebhooksDataUpgrade;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OsgiMigrationToV1
implements WebhooksDataUpgrade {
    private static final Logger log = LoggerFactory.getLogger(OsgiMigrationToV1.class);
    private final WebhookV1MigrateService webhookV1MigrateService;
    private final ExternalMigrationTaskInvokerGuard externalMigrationTaskInvokerService;

    public OsgiMigrationToV1(WebhookV1MigrateService webhookV1MigrateService, ExternalMigrationTaskInvokerGuard externalMigrationTaskInvokerService) {
        this.webhookV1MigrateService = webhookV1MigrateService;
        this.externalMigrationTaskInvokerService = externalMigrationTaskInvokerService;
    }

    public void registerExternalMigrationTask(List<WebhookDTO> webhookDTOs, Consumer<Map<Integer, Integer>> resultConsumer) {
        this.externalMigrationTaskInvokerService.migrationTask(ao -> {
            HashMap result = new HashMap();
            webhookDTOs.forEach(hook -> result.put(hook.getId(), this.webhookV1MigrateService.migrate((ActiveObjects)ao, (WebhookDTO)hook)));
            log.debug("Events migration completed successfully.");
            resultConsumer.accept(result);
        });
    }
}

