/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.dao.ao.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalMigrationTaskInvokerGuard {
    private static final Logger log = LoggerFactory.getLogger(ExternalMigrationTaskInvokerGuard.class);
    private Consumer<ActiveObjects> migrationTask;
    private ActiveObjects ao;

    public synchronized void migrationTask(Consumer<ActiveObjects> task) {
        if (this.ao != null) {
            log.info("atlassian-webhooks migration already happened, perform external migration now");
            task.accept(this.ao);
            this.ao = null;
        } else if (this.migrationTask != null) {
            log.warn("migration task already registered, ignoring");
        } else {
            this.migrationTask = task;
        }
    }

    public synchronized void onMigrationFinished(ActiveObjects ao) {
        if (this.migrationTask != null) {
            log.info("External migration task present, invoking");
            this.migrationTask.accept(ao);
            this.migrationTask = null;
        } else {
            log.info("No external migration not registered");
            this.ao = ao;
        }
    }
}

