/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.dao.ao.v3;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.webhooks.internal.dao.ao.v3.AoWebhookConfigurationEntryV3;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateToV3Task
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(MigrateToV3Task.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"3");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"2")), (Object)"Can only migrate from v2 to v3");
        log.info("Migrating webhooks to version 3, ensuring that JQL, DESCRIPTION fields have unlimited length");
        ao.migrate(new Class[]{AoWebhookConfigurationEntryV3.class});
        log.info("Migration is complete");
    }
}

