/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.core.event;

import com.atlassian.config.lifecycle.events.ApplicationStartedEvent;
import com.atlassian.event.internal.AsynchronousAbleEventDispatcher;
import com.atlassian.event.spi.EventExecutorFactory;
import com.atlassian.event.spi.ListenerInvoker;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionAwareEventDispatcher
extends AsynchronousAbleEventDispatcher {
    public static final String DISABLE_TRANSACTION = "DISABLE_TRANSACTION";
    private final TransactionTemplate transactionTemplate;

    public TransactionAwareEventDispatcher(EventExecutorFactory executorFactory, PlatformTransactionManager transactionManager) {
        this(executorFactory, new TransactionTemplate(transactionManager, (TransactionDefinition)new DefaultTransactionDefinition(3)));
    }

    @VisibleForTesting
    TransactionAwareEventDispatcher(EventExecutorFactory executorFactory, TransactionTemplate transactionTemplate) {
        super(executorFactory);
        this.transactionTemplate = transactionTemplate;
    }

    public void dispatch(ListenerInvoker invoker, Object event) {
        if (this.shouldImmediatelyDispatchEvent(invoker, event).booleanValue()) {
            super.dispatch(invoker, event);
            return;
        }
        this.transactionTemplate.execute(status -> {
            super.dispatch(invoker, event);
            return null;
        });
    }

    private Boolean shouldImmediatelyDispatchEvent(ListenerInvoker invoker, Object event) {
        return invoker.getScope().map(DISABLE_TRANSACTION::equals).orElse(false) != false || event instanceof ApplicationStartedEvent || event instanceof PluginFrameworkStartedEvent;
    }
}

