/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.Supplier;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.cache.Cache;

class EhcacheBackedCache<K, V>
implements Cache<K, V> {
    private final javax.cache.Cache<K, V> ehcache;
    private final CacheLoader<K, V> loader;

    EhcacheBackedCache(javax.cache.Cache<K, V> ehcache) {
        this(ehcache, null);
    }

    EhcacheBackedCache(javax.cache.Cache<K, V> ehcache, CacheLoader<K, V> loader) {
        this.ehcache = (javax.cache.Cache)Preconditions.checkNotNull(ehcache);
        this.loader = loader;
    }

    public boolean containsKey(@Nonnull K key) {
        return this.ehcache.get(key) != null;
    }

    @Nullable
    public V get(@Nonnull K key) {
        if (this.loader != null) {
            return this.get(key, () -> this.loader.load(key));
        }
        return (V)this.ehcache.get(key);
    }

    @Nonnull
    public V get(@Nonnull K key, @Nonnull Supplier<? extends V> valueSupplier) {
        Object val = this.ehcache.get(key);
        if (val == null) {
            val = valueSupplier.get();
            this.put(key, val);
        }
        return (V)val;
    }

    @Nonnull
    public String getName() {
        return this.ehcache.getName();
    }

    public void put(@Nonnull K key, @Nonnull V value) {
        this.ehcache.put(key, value);
    }

    @Nullable
    public V putIfAbsent(@Nonnull K key, @Nonnull V value) {
        this.ehcache.putIfAbsent(key, value);
        return value;
    }

    public void remove(@Nonnull K key) {
        this.ehcache.remove(key);
    }

    public boolean remove(@Nonnull K key, @Nonnull V value) {
        return this.ehcache.remove(key, value);
    }

    public void removeAll() {
        this.ehcache.removeAll();
    }

    public boolean replace(@Nonnull K key, @Nonnull V oldValue, @Nonnull V newValue) {
        return this.ehcache.replace(key, oldValue, newValue);
    }

    @Nonnull
    public Collection<K> getKeys() {
        return StreamSupport.stream(this.ehcache.spliterator(), false).filter(Objects::nonNull).map(Cache.Entry::getKey).collect(Collectors.toList());
    }

    public void addListener(@Nonnull CacheEntryListener<K, V> listener, boolean includeValues) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(@Nonnull CacheEntryListener<K, V> listener) {
        throw new UnsupportedOperationException();
    }
}

