/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.directory;

import com.atlassian.crowd.util.ObjectMapperFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronisationStatusKeyParamsSerde {
    private static final Logger logger = LoggerFactory.getLogger(SynchronisationStatusKeyParamsSerde.class);
    private static final ObjectReader PARAM_READER;
    private static final ObjectWriter PARAM_WRITER;

    public static List<Serializable> unmarshallParams(String marshalledParams) {
        if (Strings.nullToEmpty((String)marshalledParams).isEmpty()) {
            return new ArrayList<Serializable>();
        }
        try {
            return (List)PARAM_READER.readValue(marshalledParams);
        }
        catch (IOException ignored) {
            logger.info("Could not unmarshall synchronisation parameters : {}", (Object)marshalledParams);
            return Collections.emptyList();
        }
    }

    public static String marshallParams(List<Serializable> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        try {
            return PARAM_WRITER.writeValueAsString(params);
        }
        catch (IOException ignored) {
            logger.info("Could not marshall synchronisation parameters : {}", params);
            return "";
        }
    }

    static {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        PARAM_READER = mapper.reader((TypeReference)new TypeReference<List<String>>(){});
        PARAM_WRITER = mapper.writer();
    }
}

