/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.secret;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.crowd.secret.SecretNamespace;
import com.atlassian.crowd.secret.SecretServiceInternal;
import com.atlassian.crowd.service.HomeDirectoryService;
import com.atlassian.secrets.api.SecretDao;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceConfiguration;
import com.atlassian.secrets.api.SecretServiceDisabledException;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.service.SecretServiceFactory;
import com.atlassian.secrets.service.SecretServiceParams;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public class CrowdSecretService
implements SecretServiceInternal {
    private final SecretService delegate;

    public CrowdSecretService(SecretDao secretDao, HomeDirectoryService homeDirectoryService, ClusterLockService clusterLockService) {
        SecretServiceParams secretServiceParams = SecretServiceParams.builder().setSecretDao(secretDao).setHomeDirectory(Path.of(homeDirectoryService.getSharedHome(), new String[0])).setClusterLockServiceSupplier(() -> clusterLockService).build();
        this.delegate = SecretServiceFactory.getSecretService((SecretServiceParams)secretServiceParams);
    }

    @Transactional
    public void put(String identifier, String secretData) throws SecretServiceException {
        this.put(SecretNamespace.EXTERNAL, identifier, secretData);
    }

    @Transactional
    public void put(SecretNamespace secretNamespace, String identifier, String secretData) throws SecretServiceException {
        Objects.requireNonNull(secretData, "secretData");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)identifier), (Object)"identifier");
        this.delegate.put(secretNamespace.prependTo(identifier), secretData);
    }

    @Transactional(readOnly=true)
    public Optional<String> get(String identifier) throws SecretServiceException {
        return this.get(SecretNamespace.EXTERNAL, identifier);
    }

    @Transactional(readOnly=true)
    public Optional<String> get(SecretNamespace secretNamespace, String identifier) throws SecretServiceException {
        Objects.requireNonNull(identifier, "identifier");
        return this.delegate.get(secretNamespace.prependTo(identifier));
    }

    @Transactional
    public void delete(String identifier) throws SecretServiceException {
        this.delete(SecretNamespace.EXTERNAL, identifier);
    }

    @Transactional
    public void delete(SecretNamespace secretNamespace, String identifier) throws SecretServiceException {
        Objects.requireNonNull(identifier, "identifier");
        this.delegate.delete(secretNamespace.prependTo(identifier));
    }

    @Nonnull
    public SecretServiceConfiguration getConfiguration() throws SecretServiceDisabledException {
        return this.delegate.getConfiguration();
    }

    @Nonnull
    public SecretService.SecretServiceManagement getManagement() {
        return this.delegate.getManagement();
    }
}

