/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.common.properties.SystemProperties;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectMapperFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectMapperFactory.class);
    private static final int MAX_NESTING_DEPTH = 500;

    public static ObjectMapper getObjectMapper() {
        if (((Boolean)SystemProperties.LEGACY_OBJECT_MAPPER_CREATION.getValue()).booleanValue()) {
            LOGGER.debug("{} flag enabled. Creating ObjectMapper without constraints", (Object)SystemProperties.LEGACY_OBJECT_MAPPER_CREATION.getName());
            return new ObjectMapper();
        }
        return ObjectMapperFactory.getObjectMapperLimited();
    }

    private static ObjectMapper getObjectMapperLimited() {
        LOGGER.debug("Creating ObjectMapper with constraints. Max nesting depth: {}", (Object)500);
        StreamReadConstraints constraints = StreamReadConstraints.builder().maxNestingDepth(500).build();
        JsonFactory jsonFactory = JsonFactory.builder().streamReadConstraints(constraints).build();
        return new ObjectMapper(jsonFactory);
    }

    private ObjectMapperFactory() {
    }
}

