/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.searchui.filter;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.plugins.searchui.filter.SearchUIRequestSemaphore;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class SearchUIRequestFilter
extends HttpFilter {
    private static final Logger log = LoggerFactory.getLogger(SearchUIRequestFilter.class);
    private static final int ACQUIRE_TIMEOUT = 500;
    private static final String NEXT_UI_SEARCH = "next.ui.search";
    private final SearchUIRequestSemaphore semaphoreHolder;

    public SearchUIRequestFilter(SearchUIRequestSemaphore semaphoreHolder) {
        this.semaphoreHolder = semaphoreHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!NEXT_UI_SEARCH.equalsIgnoreCase(request.getParameter("src"))) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Semaphore semaphore = this.semaphoreHolder.getSemaphore();
        boolean acquired = false;
        try {
            acquired = semaphore.tryAcquire(500L, TimeUnit.MILLISECONDS);
            if (acquired) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.handleResponseTimeout(response);
            }
        }
        catch (InterruptedException exception) {
            log.warn(exception.getMessage(), (Throwable)exception);
            this.handleResponseTimeout(response);
        }
        finally {
            if (acquired) {
                semaphore.release();
            }
        }
    }

    private void handleResponseTimeout(HttpServletResponse response) {
        response.setStatus(408);
    }
}

