/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.searchui.filter;

import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.Semaphore;
import org.springframework.stereotype.Component;

@Component
public class SearchUIRequestSemaphore {
    private final GlobalSettingsManager settingsManager;
    private final EventPublisher eventPublisher;
    private volatile Semaphore semaphore;

    public SearchUIRequestSemaphore(@ComponentImport GlobalSettingsManager settingsManager, @ComponentImport EventPublisher eventPublisher) {
        this.settingsManager = settingsManager;
        this.eventPublisher = eventPublisher;
    }

    Semaphore getSemaphore() {
        if (this.semaphore == null) {
            this.refreshSemaphore();
        }
        return this.semaphore;
    }

    @PostConstruct
    public void setup() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void teardown() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onGlobalSettingsUpdate(GlobalSettingsChangedEvent event) {
        int newMax;
        int oldMax = event.getOldSettings().getMaxSimultaneousQuickNavRequests();
        if (oldMax != (newMax = event.getNewSettings().getMaxSimultaneousQuickNavRequests())) {
            this.refreshSemaphore();
        }
    }

    private void refreshSemaphore() {
        this.semaphore = new Semaphore(this.settingsManager.getGlobalSettings().getMaxSimultaneousQuickNavRequests(), true);
    }
}

