/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.recentlyviewed;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostViewEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentViewedListener {
    private static final Logger log = LoggerFactory.getLogger(ContentViewedListener.class);
    private final EventPublisher eventPublisher;
    private final RecentlyViewedManager recentlyViewedManager;
    private final UserManager userManager;
    private final ExecutorService executorService;

    @Autowired
    public ContentViewedListener(EventPublisher eventPublisher, RecentlyViewedManager recentlyViewedManager, UserManager userManager, ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.eventPublisher = eventPublisher;
        this.recentlyViewedManager = recentlyViewedManager;
        this.userManager = userManager;
        this.executorService = threadLocalDelegateExecutorFactory.createExecutorService(Executors.newCachedThreadPool(ThreadFactories.namedThreadFactory((String)ContentViewedListener.class.getSimpleName(), (ThreadFactories.Type)ThreadFactories.Type.DAEMON)));
    }

    private void addPageViewToHistory(Long contentId, String contentType, String spaceKey, long timestamp) {
        long start = System.currentTimeMillis();
        try {
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey != null) {
                this.recentlyViewedManager.savePageView(userKey.getStringValue(), contentId, contentType, spaceKey, timestamp);
            }
        }
        catch (Exception e) {
            log.debug("Failed to add page view to history", (Throwable)e);
        }
        log.debug("Saving history entry for page took {}ms.", (Object)(System.currentTimeMillis() - start));
    }

    private void addPageViewToHistoryAsync(Long contentId, String contentType, String spaceKey, long timestamp) {
        this.executorService.execute(() -> this.addPageViewToHistory(contentId, contentType, spaceKey, timestamp));
    }

    private void removePageViewsInHistory(Long contentId) {
        this.recentlyViewedManager.removePageViews(contentId);
    }

    @EventListener
    public void onPageView(PageViewEvent event) {
        this.addPageViewToHistoryAsync(event.getContent().getId(), StringUtils.upperCase((String)event.getContent().getType()), this.getSpaceKey(event.getContent()), event.getTimestamp());
    }

    @EventListener
    public void onBlogPostView(BlogPostViewEvent event) {
        this.addPageViewToHistoryAsync(event.getContent().getId(), StringUtils.upperCase((String)event.getContent().getType()), this.getSpaceKey(event.getContent()), event.getTimestamp());
    }

    @EventListener
    public void onPageRemove(PageRemoveEvent event) {
        this.removePageViewsInHistory(event.getContent().getId());
    }

    @EventListener
    public void onBlogPostRemove(BlogPostRemoveEvent event) {
        this.removePageViewsInHistory(event.getContent().getId());
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
        this.executorService.shutdownNow();
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    private String getSpaceKey(ContentEntityObject ceo) {
        if (ceo instanceof SpaceContentEntityObject) {
            return ((SpaceContentEntityObject)ceo).getSpaceKey();
        }
        return null;
    }
}

