/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.recentlyviewed;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AddressablePage;
import com.atlassian.confluence.plugins.recentlyviewed.api.RecentlyViewedItem;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.util.Objects;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class RecentlyViewed
implements RecentlyViewedItem {
    private long id;
    private long lastSeen;
    private String title;
    private String space;
    private String type;
    private String url;

    public RecentlyViewed() {
    }

    public RecentlyViewed(long id, long lastSeen) {
        this.id = id;
        this.lastSeen = lastSeen;
    }

    @Deprecated
    public void setPageData(AbstractPage abstractPage) {
        this.title = abstractPage.getTitle();
        this.space = abstractPage.isLatestVersion() ? abstractPage.getSpace().getName() : abstractPage.getOriginalVersionPage().getSpace().getName();
        this.type = abstractPage.getType();
        this.url = AddressablePage.of((AbstractPage)abstractPage).getUrlPath();
    }

    public void setContent(Content content) {
        this.title = content.getTitle();
        this.space = content.getSpace().getName();
        this.type = content.getType().serialise();
        this.url = ((Link)content.getLinks().get(LinkType.WEB_UI)).getPath();
    }

    public long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSpace() {
        return this.space;
    }

    public String getType() {
        return this.type;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.lastSeen, this.title, this.space, this.type, this.url);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RecentlyViewed)) {
            return false;
        }
        RecentlyViewed other = (RecentlyViewed)object;
        return Objects.equals(this.id, other.id) && Objects.equals(this.lastSeen, other.lastSeen) && Objects.equals(this.title, other.title) && Objects.equals(this.space, other.space) && Objects.equals(this.type, other.type) && Objects.equals(this.url, other.url);
    }
}

