/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.userlister;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={PluginUpgradeTask.class})
public class BandanaRemovalUpgradeTask
implements PluginUpgradeTask {
    private static final int BUILD_NUMBER = 10;
    private static final Logger log = LoggerFactory.getLogger(BandanaRemovalUpgradeTask.class);
    private final BandanaContext bandanaContext = new ConfluenceBandanaContext();
    private final BandanaManager bandanaManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ConfluenceJsonObjectMapper objectMapper = new ConfluenceJsonObjectMapper();

    public BandanaRemovalUpgradeTask(@ComponentImport @Qualifier(value="bandanaManager") BandanaManager bandanaManager, @ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.bandanaManager = bandanaManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public int getBuildNumber() {
        return 10;
    }

    @Nonnull
    public String getShortDescription() {
        return "Migrate Bandana records to Plugin Settings in confluence-user-lister-plugin.";
    }

    @Nullable
    public Collection<Message> doUpgrade() throws Exception {
        log.info("Starting migration of Bandana records to Plugin Settings for confluence-user-lister-plugin.");
        Collection blackListedGroups = (Collection)this.bandanaManager.getValue(this.bandanaContext, "com.atlassian.confluence.extra.userlister.blacklist");
        if (blackListedGroups == null) {
            log.info("Nothing to migrate for confluence-user-lister-plugin, no blacklisted groups found in Bandana.");
            return List.of();
        }
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        try {
            String blacklistJson = this.objectMapper.writeValueAsString(new HashSet(blackListedGroups));
            pluginSettings.put("com.atlassian.confluence.extra.userlister.blacklist", (Object)blacklistJson);
        }
        catch (Exception e) {
            log.error("Failed to migrate blacklisted groups to Plugin Settings", (Throwable)e);
        }
        log.info("Finished migration of Bandana records to Plugin Settings for confluence-user-lister-plugin.");
        return List.of();
    }

    @Nonnull
    public String getPluginKey() {
        return "confluence.extra.userlister";
    }
}

