/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.userlister;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.extra.userlister.UserListManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultUserListManager
implements UserListManager {
    private final CacheManager cacheManager;
    private final ConfluenceJsonObjectMapper jsonObjectMapper = new ConfluenceJsonObjectMapper();
    private final PluginSettings pluginSetting;

    @Autowired
    public DefaultUserListManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport CacheManager cacheManager) {
        this.pluginSetting = pluginSettingsFactory.createGlobalSettings();
        this.cacheManager = cacheManager;
    }

    @Override
    public Set<String> getGroupBlackList() {
        String deniedGroupsJson = (String)this.pluginSetting.get("com.atlassian.confluence.extra.userlister.blacklist");
        if (deniedGroupsJson != null) {
            try {
                Set blacklist = (Set)this.jsonObjectMapper.readValue(deniedGroupsJson, Set.class);
                return blacklist;
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Failed to parse group blacklist JSON", e);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public void saveGroupBlackList(Set<String> deniedGroups) {
        try {
            String deniedGroupsJson = this.jsonObjectMapper.writeValueAsString(deniedGroups);
            this.pluginSetting.put("com.atlassian.confluence.extra.userlister.blacklist", (Object)deniedGroupsJson);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isGroupPermitted(String groupName) {
        return StringUtils.isBlank((CharSequence)groupName) || !this.getGroupBlackList().contains(groupName);
    }

    private Cache<String, Set<String>> getLoggedInUsersCache() {
        return this.cacheManager.getCache(this.getClass().getName());
    }

    @Override
    public Set<String> getLoggedInUsers() {
        return new HashSet<String>(this.getLoggedInUsersCache().getKeys());
    }

    private Set<String> getLoggedInUserSessionIds(String userName) {
        Set sessionIds = (Set)this.getLoggedInUsersCache().get((Object)userName);
        return null == sessionIds ? new HashSet() : sessionIds;
    }

    private void cacheLoggedInUser(String userName, Set<String> sessionIds) {
        this.getLoggedInUsersCache().put((Object)userName, sessionIds);
    }

    @Override
    public void registerLoggedInUser(String userName, String sessionId) {
        Set<String> sessionIds = this.getLoggedInUserSessionIds(userName);
        sessionIds.add(sessionId);
        this.cacheLoggedInUser(userName, sessionIds);
    }

    @Override
    public void unregisterLoggedInUser(String userName, String sessionId) {
        Set<String> sessionIds = this.getLoggedInUserSessionIds(userName);
        sessionIds.remove(sessionId);
        if (sessionIds.isEmpty()) {
            this.getLoggedInUsersCache().remove((Object)userName);
        } else {
            this.cacheLoggedInUser(userName, sessionIds);
        }
    }
}

