/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.platform.security;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;

public final class PathTraversalChecker {
    public static final List<String> FORBIDDEN_PATH_EQUALS = List.of("..");
    public static final List<String> FORBIDDEN_PATH_CONTAINS = List.of("../", "..\\");
    public static final List<String> FORBIDDEN_PATH_ENDINGS = List.of("/..", "\\..");

    public static boolean isSafePath(Path path) {
        return PathTraversalChecker.isSafePath(path, StandardCharsets.UTF_8);
    }

    public static boolean isSafePath(String pathString) {
        return PathTraversalChecker.isSafePath(pathString, StandardCharsets.UTF_8);
    }

    public static boolean isSafePath(Path path, Charset charset) {
        if (path.isAbsolute()) {
            return false;
        }
        return PathTraversalChecker.isSafePath(path.toString(), charset);
    }

    public static boolean isSafePath(String pathString, Charset charset) {
        Path path = Path.of(pathString, new String[0]);
        if (path.isAbsolute()) {
            return false;
        }
        if (!path.normalize().equals(path)) {
            return false;
        }
        return !PathTraversalChecker.containsEncodedPathTraversal(pathString, charset);
    }

    public static boolean isSafeRelativePath(String pathString) {
        return PathTraversalChecker.isSafeRelativePath(pathString, StandardCharsets.UTF_8);
    }

    public static boolean isSafeRelativePath(Path relativePath) {
        return PathTraversalChecker.isSafeRelativePath(relativePath, StandardCharsets.UTF_8);
    }

    public static boolean isSafeRelativePath(Path path, Charset charset) {
        return PathTraversalChecker.isSafeRelativePath(path.toString(), charset);
    }

    public static boolean isSafeRelativePath(String relativePathString, Charset charset) {
        Path path = Path.of(relativePathString, new String[0]);
        if (!path.normalize().equals(path)) {
            return false;
        }
        return !PathTraversalChecker.containsEncodedPathTraversal(relativePathString, charset);
    }

    public static boolean isPathInSafeDirectory(String secureDir, String untrustedPath) throws IOException {
        Objects.requireNonNull(secureDir, "secureDir");
        Objects.requireNonNull(untrustedPath, "untrustedPath");
        File parentPath = new File(secureDir);
        File childPath = new File(untrustedPath);
        Path parentCanonicalPath = Paths.get(parentPath.getCanonicalPath(), new String[0]);
        Path childCanonicalPath = Paths.get(childPath.getCanonicalPath(), new String[0]);
        return childCanonicalPath.startsWith(parentCanonicalPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsPathTraversal(String str) {
        if (FORBIDDEN_PATH_EQUALS.stream().anyMatch(str::equals)) return true;
        if (FORBIDDEN_PATH_CONTAINS.stream().anyMatch(str::contains)) return true;
        if (!FORBIDDEN_PATH_ENDINGS.stream().anyMatch(str::endsWith)) return false;
        return true;
    }

    private static boolean containsEncodedPathTraversal(String str, Charset charset) {
        return PathTraversalChecker.containsPathTraversal(PathTraversalChecker.loopedUrlDecode(str, charset));
    }

    static String loopedUrlDecode(String str, Charset charset) {
        String prev;
        int i = 0;
        do {
            prev = str;
            try {
                str = URLDecoder.decode(prev, charset);
            }
            catch (IllegalArgumentException e) {
                str = PathTraversalChecker.resoluteUrlDecode(prev, charset);
            }
        } while (!str.equals(prev) && i++ < 100);
        return str;
    }

    private static String resoluteUrlDecode(String encodedStr, Charset charset) {
        Objects.requireNonNull(encodedStr, "String");
        Objects.requireNonNull(charset, "Charset");
        return new String(PathTraversalChecker.resoluteUrlDecode(encodedStr.getBytes(StandardCharsets.UTF_8)), charset);
    }

    private static byte[] resoluteUrlDecode(byte[] bytes) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            int initI = i;
            byte b = bytes[i];
            if (b == 43) {
                buffer.write(32);
                continue;
            }
            if (b == 37) {
                try {
                    int u = Character.digit((char)bytes[++i], 16);
                    int l = Character.digit((char)bytes[++i], 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException();
                    }
                    buffer.write((char)((u << 4) + l));
                }
                catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                    buffer.write(b);
                    i = initI;
                }
                continue;
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }
}

