/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.platform.security.file;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;

@FunctionalInterface
public interface FileContentProvider {
    public static FileContentProvider fromSupplier(final Supplier<InputStream> supplier) {
        return new FileContentProvider(){

            @Override
            public <T> T processFile(ThrowingFunction<InputStream, T, IOException> fileProcessor) throws IOException {
                try (InputStream inputStream = (InputStream)supplier.get();){
                    T t = fileProcessor.apply(inputStream);
                    return t;
                }
            }
        };
    }

    public <T> T processFile(ThrowingFunction<InputStream, T, IOException> var1) throws IOException;

    @FunctionalInterface
    public static interface ThrowingFunction<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

