/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.viewfile.macro;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.plugins.viewfile.macro.ViewFileMacroUtils;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
public class FilePlaceholderGeneratorServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String fileType = URLDecoder.decode((String)StringUtils.defaultIfBlank((CharSequence)req.getParameter("type"), (CharSequence)""), StandardCharsets.UTF_8);
        String fileName = URLDecoder.decode((String)StringUtils.defaultIfBlank((CharSequence)req.getParameter("name"), (CharSequence)""), StandardCharsets.UTF_8);
        String fileHeight = (String)StringUtils.defaultIfBlank((CharSequence)req.getParameter("height"), (CharSequence)"");
        try (ServletOutputStream outputStream = resp.getOutputStream();){
            BufferedImage bufferedImage = ViewFileMacroUtils.getPlaceholderWithFileName(fileName, fileType, fileHeight);
            resp.setContentType("image/png");
            ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)outputStream);
        }
    }
}

