/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.api;

import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.mail.InboundMailServer;
import com.atlassian.confluence.plugins.emailgateway.api.EmailGatewaySettingsManager;
import com.atlassian.confluence.plugins.emailgateway.api.analytics.CreatePageByEmailAnalytics;
import com.atlassian.confluence.plugins.emailgateway.api.analytics.ReplyToCommentByEmailAnalytics;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.server.MailServer;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEmailGatewaySettingsManager
implements EmailGatewaySettingsManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEmailGatewaySettingsManager.class);
    public static final String EMAIL_GATEWAY_CONFIGURATION_NAMESPACE = "email-gateway-configuration";
    private final EventPublisher eventPublisher;
    private final ObjectMapper objectMapper = new ConfluenceJsonObjectMapper();
    private final PluginSettings pluginSettings;

    public DefaultEmailGatewaySettingsManager(EventPublisher eventPublisher, PluginSettingsFactory pluginSettingsFactory) {
        this.eventPublisher = eventPublisher;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(EMAIL_GATEWAY_CONFIGURATION_NAMESPACE);
    }

    @Override
    public boolean isAllowToCreatePageByEmail() {
        return this.getBoolean("com.atlassian.confluence.plugins.emailgateway.allow.create.page");
    }

    @Override
    public boolean isAllowToCreateCommentByEmail() {
        return this.getBoolean("com.atlassian.confluence.plugins.emailgateway.allow.create.comment");
    }

    @Override
    public InboundMailServer getDefaultInboundMailServer() {
        Object mailServerJson = this.pluginSettings.get("com.atlassian.confluence.plugins.emailgateway.default.pop.server");
        if (mailServerJson == null) {
            return null;
        }
        try {
            return (InboundMailServer)this.objectMapper.readValue((String)mailServerJson, InboundMailServer.class);
        }
        catch (JsonProcessingException e) {
            LOG.error("Failed to parse inbound mail server configuration", (Throwable)e);
            return null;
        }
    }

    @Override
    public void setAllowToCreatePageByEmail(boolean allowToCreatePageByEmail) {
        this.pluginSettings.put("com.atlassian.confluence.plugins.emailgateway.allow.create.page", (Object)allowToCreatePageByEmail);
        this.eventPublisher.publish(allowToCreatePageByEmail ? new CreatePageByEmailAnalytics.EnableFeatureEvent() : new CreatePageByEmailAnalytics.DisableFeatureEvent());
    }

    @Override
    public void setAllowToCreateCommentByEmail(boolean allowToCreateCommentByEmail) {
        this.pluginSettings.put("com.atlassian.confluence.plugins.emailgateway.allow.create.comment", (Object)allowToCreateCommentByEmail);
        this.eventPublisher.publish(allowToCreateCommentByEmail ? new ReplyToCommentByEmailAnalytics.EnableFeatureEvent() : new ReplyToCommentByEmailAnalytics.DisableFeatureEvent());
    }

    @Override
    public void setDefaultMailServer(MailServer mailServer) {
        try {
            String jsonString = this.objectMapper.writeValueAsString((Object)mailServer);
            this.pluginSettings.put("com.atlassian.confluence.plugins.emailgateway.default.pop.server", (Object)jsonString);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean getBoolean(String key) {
        return Boolean.TRUE.equals(this.pluginSettings.get(key));
    }
}

