/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.converter;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.Marshaller;
import com.atlassian.confluence.content.render.xhtml.MarshallingRegistry;
import com.atlassian.confluence.content.render.xhtml.MarshallingType;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Unmarshaller;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.migration.UrlResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.transformers.FragmentTransformer;
import com.atlassian.confluence.plugins.emailgateway.api.LinkConverter;
import com.atlassian.confluence.plugins.emailgateway.linkconverter.LinkConverterService;
import com.atlassian.confluence.xhtml.api.Link;
import io.atlassian.util.concurrent.Lazy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Supplier;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;

public class LinkFragmentTransformer
implements FragmentTransformer {
    private final Supplier<Unmarshaller<Link>> emailLinkUnmarshaller;
    private final MarshallingRegistry marshallingRegistry;
    private final LinkConverterService linkConverterService;

    public LinkFragmentTransformer(MarshallingRegistry marshallingRegistry, LinkConverterService linkConverterService) {
        this.marshallingRegistry = marshallingRegistry;
        this.emailLinkUnmarshaller = Lazy.supplier(() -> marshallingRegistry.getUnmarshaller(Link.class, MarshallingType.EMAIL));
        this.linkConverterService = linkConverterService;
    }

    public boolean handles(StartElement startElementEvent, ConversionContext conversionContext) {
        return this.getLinkUnmarshaller().handles(startElementEvent, conversionContext);
    }

    public Streamable transform(XMLEventReader reader, FragmentTransformer mainFragmentTransformer, ConversionContext conversionContext) throws XhtmlException {
        Link link = (Link)this.getLinkUnmarshaller().unmarshal(reader, mainFragmentTransformer, conversionContext);
        URL linkUrl = this.getLinkURL(link);
        Class conversionClass = Link.class;
        Object converted = null;
        for (LinkConverter<?, ?> linkConverter : this.linkConverterService.getLinkConverters()) {
            converted = linkConverter.convert(linkUrl, link.getBody());
            if (converted == null) continue;
            if (converted instanceof Link && !linkConverter.isFinal()) {
                link = converted;
                linkUrl = this.getLinkURL(link);
                continue;
            }
            conversionClass = linkConverter.getConversionClass();
            break;
        }
        if (null == converted) {
            converted = link;
        }
        Marshaller storageMarshaller = this.marshallingRegistry.getMarshaller(conversionClass, MarshallingType.STORAGE);
        return storageMarshaller.marshal(converted, conversionContext);
    }

    private URL getLinkURL(Link link) {
        UrlResourceIdentifier ri = (UrlResourceIdentifier)link.getDestinationResourceIdentifier();
        String urlStr = ri.getUrl();
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private Unmarshaller<Link> getLinkUnmarshaller() {
        return this.emailLinkUnmarshaller.get();
    }
}

