/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.notifications;

import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.RenderContextProviderTemplate;
import com.atlassian.confluence.plugins.emailgateway.events.EmailHandlingExceptionPayload;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DefaultEmailHandlingExceptionRenderContextFactory
extends RenderContextProviderTemplate<EmailHandlingExceptionPayload> {
    private final I18NBeanFactory i18NBeanFactory;
    private final GlobalSettingsManager settingsManager;

    public DefaultEmailHandlingExceptionRenderContextFactory(I18NBeanFactory i18NBeanFactory, GlobalSettingsManager settingsManager) {
        super(EmailHandlingExceptionPayload.class);
        this.i18NBeanFactory = i18NBeanFactory;
        this.settingsManager = settingsManager;
    }

    protected Optional<Map<String, Object>> checkedCreate(Notification<EmailHandlingExceptionPayload> notification, ServerConfiguration serverConfiguration, RoleRecipient roleRecipient) {
        return Optional.empty();
    }

    protected Optional<Map<String, Object>> checkedCreate(Notification<EmailHandlingExceptionPayload> notification, ServerConfiguration serverConfiguration, NotificationAddress notificationAddress) {
        String emailSubjectTitle;
        String emailSubject;
        EmailHandlingExceptionPayload payload = (EmailHandlingExceptionPayload)notification.getPayload();
        HashMap context = Maps.newHashMapWithExpectedSize((int)5);
        if (payload.isCreatePageError()) {
            emailSubject = this.i18NBeanFactory.getI18NBean().getText("email.gateway.no.matching.user.page.emailsubject", (Object[])new String[]{this.settingsManager.getGlobalSettings().getSiteTitle()});
            emailSubjectTitle = this.i18NBeanFactory.getI18NBean().getText(payload.isAttachmentError() ? "email.gateway.big.attachment.page.emailsubjecttitle" : "email.gateway.no.matching.user.page.emailsubjecttitle");
        } else {
            emailSubject = this.i18NBeanFactory.getI18NBean().getText("email.gateway.no.matching.user.comment.emailsubject", (Object[])new String[]{this.settingsManager.getGlobalSettings().getSiteTitle()});
            emailSubjectTitle = this.i18NBeanFactory.getI18NBean().getText(payload.isAttachmentError() ? "email.gateway.big.attachment.comment.emailsubjecttitle" : "email.gateway.no.matching.user.comment.emailsubjecttitle");
        }
        context.put("subject", emailSubject);
        context.put("subjectTitle", emailSubjectTitle);
        context.put("emailSubject", payload.getEmailSubject());
        context.put("createPageError", payload.isCreatePageError());
        context.put("attachmentError", payload.isAttachmentError());
        return Optional.of(context);
    }
}

