/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.polling;

import com.atlassian.confluence.mail.InboundMailServer;
import com.google.common.base.Predicate;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;

public class MessageRecipientFilter
implements Predicate<MimeMessage> {
    private final String expectedAddress;

    public MessageRecipientFilter(InboundMailServer inboundMailServer) {
        this.expectedAddress = inboundMailServer.getToAddress();
    }

    public boolean apply(MimeMessage input) {
        try {
            Address[] recipients = input.getRecipients(Message.RecipientType.TO);
            if (recipients == null) {
                return false;
            }
            for (Address recipient : recipients) {
                String actualAddress = ((InternetAddress)recipient).getAddress();
                if (!actualAddress.equals(this.expectedAddress)) continue;
                return true;
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        return false;
    }
}

