/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.polling;

import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import jakarta.annotation.Nullable;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MessageSizeFilter
implements Predicate<MimeMessage> {
    private static final Logger log = LoggerFactory.getLogger(MessageSizeFilter.class);
    private final long maxSizeThreshold;

    public MessageSizeFilter(GlobalSettingsManager settingsManager) {
        Settings globalSettings = settingsManager.getGlobalSettings();
        this.maxSizeThreshold = globalSettings.getAttachmentMaxSize() * (long)globalSettings.getMaxAttachmentsInUI();
    }

    public boolean apply(@Nullable MimeMessage mimeMessage) {
        boolean pass = false;
        try {
            if (mimeMessage != null) {
                int messageSize = MessageSizeFilter.sizeOfInBytes(mimeMessage);
                if ((long)messageSize > this.maxSizeThreshold) {
                    log.warn("mimeMessage {} is too large ({} > {})", (Object[])new String[]{mimeMessage.getMessageID(), String.format("%,d bytes", messageSize), String.format("%,d bytes", this.maxSizeThreshold)});
                } else {
                    pass = true;
                }
            } else {
                log.error("mimeMessage is null, cannot apply filter");
            }
            return pass;
        }
        catch (MessagingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static int sizeOfInBytes(MimeMessage mimeMessage) {
        int n;
        block8: {
            InputStream inputStream = mimeMessage.getRawInputStream();
            try {
                CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)new NullOutputStream());
                IOUtils.copy((InputStream)inputStream, (OutputStream)countingOutputStream);
                inputStream.close();
                n = countingOutputStream.getCount();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MessagingException | IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            inputStream.close();
        }
        return n;
    }
}

