/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.service;

import com.atlassian.confluence.api.service.settings.ExtendedPluginSettings;
import com.atlassian.confluence.api.service.settings.ExtendedPluginSettingsFactory;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.plugins.emailgateway.api.StagedEmailThread;
import com.atlassian.confluence.plugins.emailgateway.api.StagedEmailThreadKey;
import com.atlassian.confluence.plugins.emailgateway.service.StagedEmailThreadManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PluginSettingsStagedEmailThreadManager
implements StagedEmailThreadManager {
    public static final String EMAIL_TO_PAGE_NAMESPACE = "email-to-page";
    private static final String KEY_PREFIX = "staged-email:";
    private final ObjectMapper objectMapper = new ConfluenceJsonObjectMapper();
    private final ExtendedPluginSettings pluginSettings;

    public PluginSettingsStagedEmailThreadManager(ExtendedPluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(EMAIL_TO_PAGE_NAMESPACE);
    }

    @Override
    public void storeStagedEmailThread(StagedEmailThread stagedEmailThread) {
        try {
            String stagedEmailThreadJson = this.objectMapper.writeValueAsString((Object)stagedEmailThread);
            this.pluginSettings.put(PluginSettingsStagedEmailThreadManager.buildPluginSettingsKey(stagedEmailThread.getKey()), (Object)stagedEmailThreadJson);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize StagedEmailThread", e);
        }
    }

    @Override
    public StagedEmailThread findStagedEmailThread(StagedEmailThreadKey stagedEmailThreadKey) {
        try {
            return this.findStagedEmailThread(PluginSettingsStagedEmailThreadManager.buildPluginSettingsKey(stagedEmailThreadKey));
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private StagedEmailThread findStagedEmailThread(String key) throws JsonProcessingException {
        Object stagedEmailThreadJson = this.pluginSettings.get(key);
        return (StagedEmailThread)this.objectMapper.readValue((String)stagedEmailThreadJson, StagedEmailThread.class);
    }

    @Override
    public void deleteStagedEmailThread(StagedEmailThreadKey stagedEmailThreadKey) {
        this.pluginSettings.remove(PluginSettingsStagedEmailThreadManager.buildPluginSettingsKey(stagedEmailThreadKey));
    }

    @Override
    public Iterator<StagedEmailThread> iterator() {
        return new Iterator<StagedEmailThread>(){
            private final Iterable<String> keys;
            private final Iterator<String> keyIterator;
            private boolean shouldRead;
            private StagedEmailThread last;
            public boolean ended;
            {
                this.keys = PluginSettingsStagedEmailThreadManager.this.pluginSettings.getKeys();
                this.keyIterator = this.keys.iterator();
                this.shouldRead = true;
                this.last = null;
                this.ended = false;
            }

            private void doRead() {
                while (this.keyIterator.hasNext()) {
                    String key = this.keyIterator.next();
                    if (!key.startsWith(PluginSettingsStagedEmailThreadManager.KEY_PREFIX)) continue;
                    try {
                        this.last = PluginSettingsStagedEmailThreadManager.this.findStagedEmailThread(key);
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                    return;
                }
                this.ended = true;
            }

            @Override
            public boolean hasNext() {
                if (this.shouldRead) {
                    this.doRead();
                }
                this.shouldRead = false;
                return !this.ended;
            }

            @Override
            public StagedEmailThread next() {
                if (this.shouldRead) {
                    this.doRead();
                }
                if (this.ended) {
                    throw new NoSuchElementException();
                }
                this.shouldRead = true;
                return this.last;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove StagedEmailThreads via the deleteStagedEmailThread method");
            }
        };
    }

    private static String buildPluginSettingsKey(StagedEmailThreadKey stagedEmailThreadKey) {
        return KEY_PREFIX + stagedEmailThreadKey.getToken();
    }
}

