/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.upgrade;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.mail.InboundMailServer;
import com.atlassian.confluence.plugin.PluginUpgradeFinalizationTask;
import com.atlassian.confluence.plugins.emailgateway.api.StagedEmailThread;
import com.atlassian.confluence.setup.bandana.NoParentBandanaContext;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BandanaRemovalUpgradeTask
implements PluginUpgradeFinalizationTask {
    private static final int BUILD_NUMBER = 10;
    private static final Logger log = LoggerFactory.getLogger(BandanaRemovalUpgradeTask.class);
    private static final NoParentBandanaContext BANDANA_CONTEXT = new NoParentBandanaContext("email-to-page");
    private static final NoParentBandanaContext BANDANA_EMAIL_GATEWAY_CONFIGURATION_CONTEXT = new NoParentBandanaContext("email-gateway-configuration");
    private BandanaManager bandanaManager;
    private final PluginSettingsFactory pluginSettingsFactory;

    public BandanaRemovalUpgradeTask(BandanaManager bandanaManager, PluginSettingsFactory pluginSettingsFactory) {
        this.bandanaManager = bandanaManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public int getBuildNumber() {
        return 10;
    }

    @Nonnull
    public String getShortDescription() {
        return "Migrate Bandana records to Plugin Settings in confluence-email-gateway.";
    }

    @Nullable
    public Collection<Message> doUpgrade() throws Exception {
        log.info("Migrating confluence-email-gateway.");
        ConfluenceJsonObjectMapper objectMapper = new ConfluenceJsonObjectMapper();
        Iterable keys = this.bandanaManager.getKeys((BandanaContext)BANDANA_CONTEXT);
        for (String key : keys) {
            try {
                StagedEmailThread oldStagedEmailThread = (StagedEmailThread)this.bandanaManager.getValue((BandanaContext)BANDANA_CONTEXT, key);
                if (oldStagedEmailThread == null) {
                    log.warn("Failed to migrate bandana key {}. No value found.", (Object)key);
                    continue;
                }
                String newStagedEmailThread = objectMapper.writeValueAsString((Object)oldStagedEmailThread);
                this.pluginSettingsFactory.createSettingsForKey(BANDANA_CONTEXT.getContextKey()).put(key, (Object)newStagedEmailThread);
            }
            catch (Exception e) {
                log.error("Failed to migrate bandana key {}. Error: {}", new Object[]{key, e.getMessage(), e});
            }
        }
        try {
            InboundMailServer defaultMailServer = (InboundMailServer)this.bandanaManager.getValue((BandanaContext)BANDANA_EMAIL_GATEWAY_CONFIGURATION_CONTEXT, "com.atlassian.confluence.plugins.emailgateway.default.pop.server");
            if (defaultMailServer != null) {
                String defaultMailServerJson = objectMapper.writeValueAsString((Object)defaultMailServer);
                this.pluginSettingsFactory.createSettingsForKey("email-gateway-configuration").put("com.atlassian.confluence.plugins.emailgateway.default.pop.server", (Object)defaultMailServerJson);
            }
        }
        catch (Exception e) {
            log.error("Failed to migrate bandana key {}. Error: {}", new Object[]{"com.atlassian.confluence.plugins.emailgateway.default.pop.server", e.getMessage(), e});
        }
        return List.of();
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.confluence.plugins.confluence-email-gateway";
    }
}

