/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.rvsync.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncCursor;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionSpec;
import com.atlassian.confluence.internal.api.service.incrementalsync.IncrementalSyncService;
import com.atlassian.confluence.plugins.restapi.rvsync.resources.model.IncrementalSyncCursorModel;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;

public abstract class AbstractIncrementalSyncResource<S extends SubscriptionSpec, M extends IncrementalSyncModel> {
    protected static final String RL_PROPERTY_PREFIX = "confluence.incremental.sync.rl.";
    protected static final String CURSOR = "cursor";
    protected static final String LIMIT = "limit";
    protected static final String ID = "id";
    protected IncrementalSyncService<S, M> incrementalSyncService;

    protected AbstractIncrementalSyncResource(IncrementalSyncService<S, M> incrementalSyncService) {
        this.incrementalSyncService = incrementalSyncService;
    }

    @Operation(summary="Unsubscribes from incremental sync updates", description="Unsubscribe from incremental sync. Use subscriptionId returned by subscribe operation to unsubscribe")
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Returned if operation is successful"), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have required permissions", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if a subscription ID is not provided", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if the provided subscription ID is not found or is inactive", restError=true)})
    @DELETE
    @Path(value="subscription/{id}")
    @RateLimited
    @ScopesAllowed(requiredScope={"MANAGE_SUBSCRIPTIONS"})
    public Response unsubscribe(@PathParam(value="id") Long id) {
        if (id == null) {
            throw new BadRequestException("Subscription id must be provided");
        }
        SubscriptionId subscriptionId = SubscriptionId.of((long)id);
        this.incrementalSyncService.unsubscribe(subscriptionId);
        return Response.noContent().build();
    }

    @Operation(summary="Get the latest cursor for specified a subscription", description="For the provided subscription, returns the latest content management cursor, which contains an ID corresponding to the most recent content management journal entry.")
    @Parameter(name="id", description="The ID of the subscription the cursor should correspond to, that was returned during subscription", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returned if latest cursor found and returned.", representation=IncrementalSyncCursorModel.class), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have required permissions", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if the subscription ID is not provided", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if no active subscription with provided subscription ID found", restError=true)})
    @GET
    @Path(value="/subscription/lastcursor/{id}")
    @RateLimited
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public Response getLatestCursorForSubscription(@PathParam(value="id") Long id) {
        if (id == null) {
            throw new BadRequestException("Subscription ID must be provided");
        }
        IncrementalSyncCursor mostRecentCursor = this.incrementalSyncService.getMostRecentCursor(id.longValue());
        IncrementalSyncCursorModel cursorModel = new IncrementalSyncCursorModel(mostRecentCursor.toString());
        return Response.ok((Object)cursorModel).build();
    }

    @Operation(summary="Get all active subscriptions", description="Returns all active subscriptions")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns list of active subscriptions, Can be empty if no active subscriptions found.", representation=SubscriptionId.class, paged=true), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have required permissions", restError=true)})
    @GET
    @Path(value="/subscriptions")
    @RateLimited
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public Response getActiveSubscriptions() {
        return Response.ok((Object)this.incrementalSyncService.getAvailableSubscriptions()).build();
    }

    protected IncrementalSyncCursor validateCursor(String cursor) {
        try {
            return IncrementalSyncCursor.of((String)cursor);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid cursor format. Please use cursor that was provided during subscription.", (Throwable)e);
        }
    }

    protected int maybeAdjustLimit(int limit) {
        return Math.min(limit, this.incrementalSyncService.getEventsBatchLimit());
    }
}

