/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.rvsync.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncCursor;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncPageResponse;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionEventType;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionSpec;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentSubscriptionSpec;
import com.atlassian.confluence.internal.api.service.incrementalsync.contentmanagement.ContentManagementIncrementalSyncService;
import com.atlassian.confluence.plugins.restapi.rvsync.resources.AbstractIncrementalSyncResource;
import com.atlassian.confluence.plugins.restapi.rvsync.resources.model.ContentSubscriptionRequest;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashSet;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AdminOnly
@SendsAnalytics
@Tag(name="Incremental sync")
@Path(value="/contentmanagement/event")
@Hidden
@LogRequestInfo(headerNames={"X-B3-Traceid", "X-B3-Spanid"}, methods={"GET"})
public class ContentManagementIncrementalSyncResource
extends AbstractIncrementalSyncResource<ContentSubscriptionSpec, ContentManagementIncSyncModel> {
    @Inject
    public ContentManagementIncrementalSyncResource(ContentManagementIncrementalSyncService incrementalSyncService) {
        super(incrementalSyncService);
    }

    @Operation(summary="Subscribe to content management incremental sync", description="Performs subscription to content management incremental sync.")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returned if subscription is successful.", representation=SubscriptionId.class), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have required permissions.", restError=true)})
    @Parameter(name="types", description="Case-insensitive list of content types to listen to for syncing. Options are:Comment, Page, Blogpost, to be included in the request body. e.g. 'types': ['Comment', 'Page', 'Blogpost']")
    @POST
    @Path(value="/subscription")
    @Consumes(value={"application/json"})
    @RateLimited
    @ScopesAllowed(requiredScope={"MANAGE_SUBSCRIPTIONS"})
    public Response subscribe(ContentSubscriptionRequest request) {
        if (request == null || request.getTypes().isEmpty()) {
            throw new BadRequestException("At least one supported content event type should be provided");
        }
        HashSet<SubscriptionEventType> supportedContentEventTypes = new HashSet<SubscriptionEventType>();
        for (String type : request.getTypes()) {
            try {
                supportedContentEventTypes.add(SubscriptionEventType.valueOf((String)(type.trim().toUpperCase() + "_EVENT")));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Unsupported content event type: " + type);
            }
        }
        ContentSubscriptionSpec subscriptionSpec = new ContentSubscriptionSpec(supportedContentEventTypes);
        SubscriptionId subscriptionId = this.incrementalSyncService.subscribe((SubscriptionSpec)subscriptionSpec);
        return Response.ok((Object)subscriptionId).build();
    }

    @Operation(summary="Get next batch of content management events", description="Returns batch of content management events", extensions={@Extension(name="x-response-metadata", properties={@ExtensionProperty(name="cursorPaged", value="true")})})
    @Parameters(value={@Parameter(name="cursor", description="the identifier which is used to skip results from a previous query when paginating", in=ParameterIn.QUERY), @Parameter(name="limit", description="(optional) the limit of the number of items to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns a JSON representation of all content management events that happened after last seen records.", representation=ContentManagementIncSyncModel.class, paged=true), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have required permissions", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if cursor is invalid or if the provided subscription was not found or has been deactivated", restError=true)})
    @GET
    @RateLimited(propertyName="confluence.incremental.sync.rl.content.rps", permitsPerSecond=3.0)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<ContentManagementIncSyncModel> getEventsBatch(@QueryParam(value="cursor") String cursor, @QueryParam(value="limit") @DefaultValue(value="100") int limit, @Context UriInfo uriInfo) {
        IncrementalSyncCursor currentCursor = this.validateCursor(cursor);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), (Cursor)currentCursor, this.maybeAdjustLimit(limit));
        IncrementalSyncPageResponse response = this.incrementalSyncService.processEvents((PageRequest)pageRequest);
        RestPageRequest restPageRequest = new RestPageRequest(uriInfo.getRequestUri(), (Cursor)currentCursor, response.getPageRequest().getLimit());
        return IncrementalSyncPageResponse.builder().from(response).setPageRequest((PageRequest)restPageRequest).build();
    }
}

