/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.rvsync.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncCursor;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncPageResponse;
import com.atlassian.confluence.internal.api.incrementalsync.model.SimpleSubscriptionSpec;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionSpec;
import com.atlassian.confluence.internal.api.incrementalsync.model.globalpermissionmanagement.GlobalPermissionManagementIncSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.globalpermissionmanagement.GlobalPermissionManagementIncrementalSyncService;
import com.atlassian.confluence.plugins.restapi.rvsync.resources.AbstractIncrementalSyncResource;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AdminOnly
@SendsAnalytics
@Tag(name="Incremental sync")
@Path(value="/permission/event")
@LogRequestInfo(headerNames={"X-B3-Traceid", "X-B3-Spanid"}, methods={"GET"})
public class GlobalPermissionManagementIncrementalSyncResource
extends AbstractIncrementalSyncResource<SimpleSubscriptionSpec, GlobalPermissionManagementIncSyncModel> {
    @Inject
    public GlobalPermissionManagementIncrementalSyncResource(GlobalPermissionManagementIncrementalSyncService incrementalSyncService) {
        super(incrementalSyncService);
    }

    @Operation(summary="Subscribe to global permission management incremental sync", description="Performs subscription to global permission management incremental sync")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returned if subscription is successful.", representation=SubscriptionId.class), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have required permissions", restError=true), @ResponseDoc(responseCode=501, documentation="Returned if the there is an existing subscription", restError=true)})
    @POST
    @Path(value="/subscription")
    @RateLimited
    @ScopesAllowed(requiredScope={"MANAGE_SUBSCRIPTIONS"})
    public Response subscribe() {
        SimpleSubscriptionSpec subscriptionSpec = new SimpleSubscriptionSpec();
        SubscriptionId subscriptionId = this.incrementalSyncService.subscribe((SubscriptionSpec)subscriptionSpec);
        return Response.ok((Object)subscriptionId).build();
    }

    @Operation(summary="Get next batch of global permission management events", description="Returns batch of global permission management events", extensions={@Extension(name="x-response-metadata", properties={@ExtensionProperty(name="cursorPaged", value="true")})})
    @Parameters(value={@Parameter(name="cursor", description="the identifier which is used to skip results from a previous query when paginating", in=ParameterIn.QUERY), @Parameter(name="limit", description="(optional) the limit of the number of items to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns a JSON representation of all user management events that happened after last seen records.", representation=GlobalPermissionManagementIncSyncModel.class, paged=true), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have required permissions", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if cursor is invalid or if the provided subscription was not found or has been deactivated", restError=true)})
    @GET
    @RateLimited(propertyName="confluence.incremental.sync.rl.permissions.global.rps", permitsPerSecond=2.0)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<GlobalPermissionManagementIncSyncModel> getEventsBatch(@QueryParam(value="cursor") String cursor, @QueryParam(value="limit") @DefaultValue(value="5000") int limit, @Context UriInfo uriInfo) {
        IncrementalSyncCursor currentCursor = this.validateCursor(cursor);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), (Cursor)currentCursor, this.maybeAdjustLimit(limit));
        IncrementalSyncPageResponse response = this.incrementalSyncService.processEvents((PageRequest)pageRequest);
        RestPageRequest restPageRequest = new RestPageRequest(uriInfo.getRequestUri(), (Cursor)currentCursor, response.getPageRequest().getLimit());
        return IncrementalSyncPageResponse.builder().from(response).setPageRequest((PageRequest)restPageRequest).build();
    }
}

