/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.rvsync.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.content.LimitedSpace;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;

@Produces(value={"application/json"})
@AdminOnly
@SendsAnalytics
@Tag(name="Limited Space Resource")
@Path(value="/space/limitedspaces")
public class LimitedSpaceResource {
    SpaceFilteringService spaceFilteringService;
    ApplicationProperties applicationProperties;

    @Inject
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public LimitedSpaceResource(SpaceFilteringService spaceFilteringService, @ComponentImport ApplicationProperties applicationProperties) {
        this.spaceFilteringService = spaceFilteringService;
        this.applicationProperties = applicationProperties;
    }

    @Operation(summary="Get limited space information with offset-based pagination", description="Returns a paginated list of spaces with minimal information (ID, space name, key, icon URL) for synchronization purposes")
    @Parameters(value={@Parameter(name="start", description="The starting index for pagination (0-based)", in=ParameterIn.QUERY), @Parameter(name="limit", description="(optional) The limit of the number of items to return, 50 by default", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns a JSON representation of limited space information with offset-based pagination.", representation=LimitedSpace.class, paged=true), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have required permissions", restError=true)})
    @GET
    @Path(value="/all")
    @RateLimited
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<LimitedSpace> getAllLimitedSpaces(@QueryParam(value="start") @DefaultValue(value="0") Integer start, @DefaultValue(value="50") @QueryParam(value="limit") Integer limit, @Context UriInfo uriInfo) throws ServiceException {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start.intValue(), limit.intValue());
        PageResponse spacePageResponse = this.spaceFilteringService.getSpaces((PageRequest)pageRequest);
        PageResponse<LimitedSpace> limitedSpacePageResponse = this.convertSpacesToLimitedSpaces((PageResponse<Space>)spacePageResponse);
        return RestList.newRestList(limitedSpacePageResponse).pageRequest((PageRequest)pageRequest).build();
    }

    private PageResponse<LimitedSpace> convertSpacesToLimitedSpaces(PageResponse<Space> spacePageResponse) {
        String absoluteDefaultIconUrl = LimitedSpace.createAbsoluteLink((String)"/images/logo/default-space-logo.svg", (String)this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        List<LimitedSpace> limitedSpaces = spacePageResponse.getResults().stream().map(space -> new LimitedSpace(Long.valueOf(space.getId()), space.getName().isEmpty() ? space.getKey() : space.getName(), space.getKey(), absoluteDefaultIconUrl)).toList();
        return PageResponseImpl.from(limitedSpaces, (boolean)spacePageResponse.hasMore()).pageRequest(spacePageResponse.getPageRequest()).nextCursor(spacePageResponse.getNextCursor()).prevCursor(spacePageResponse.getPrevCursor()).totalCount(spacePageResponse.getTotalCount()).build();
    }
}

