/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.rvsync.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.internal.api.incrementalsync.model.ConfluenceRovoCapabilities;
import com.atlassian.confluence.internal.api.rovo.service.RovoCapabilityService;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Produces(value={"application/json"})
@AdminOnly
@SendsAnalytics
@Tag(name="Confluence Rovo Capability")
@Path(value="/capability/rovo")
@LogRequestInfo(headerNames={"X-B3-Traceid", "X-B3-Spanid"}, methods={"GET"})
public class RovoCapabilityResource {
    private final RovoCapabilityService rovoCapabilityService;

    @Inject
    public RovoCapabilityResource(RovoCapabilityService rovoCapabilityService) {
        this.rovoCapabilityService = rovoCapabilityService;
    }

    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Return JSON representation of Rovo capabilities of the current Confluence instance and its version", representation=ConfluenceRovoCapabilities.class), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have required permissions", restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ_ALL"})
    @RateLimited
    public Response getCapabilities() {
        ConfluenceRovoCapabilities capabilityContainer = this.rovoCapabilityService.getCapabilities();
        if (capabilityContainer == null || capabilityContainer.getCapabilities().isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)capabilityContainer).build();
    }
}

