/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.rvsync.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.internal.api.security.exception.IdsNotFoundException;
import com.atlassian.confluence.plugins.restapi.rvsync.resources.exception.RequestValidationException;
import com.atlassian.confluence.plugins.restapi.rvsync.resources.model.SpaceFilteringByIdsRequest;
import com.atlassian.confluence.plugins.restapi.rvsync.resources.model.SpaceFilteringByKeysRequest;
import com.atlassian.confluence.plugins.restapi.rvsync.resources.model.SpacesFilterModel;
import com.atlassian.confluence.plugins.restapi.rvsync.resources.model.error.MissingSpaceIdsResponse;
import com.atlassian.confluence.plugins.restapi.rvsync.resources.model.error.SpaceFilteringValidationErrorResponse;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.stream.Collectors;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AdminOnly
@SendsAnalytics
@Tag(name="Spaces allowlist")
@Path(value="/space/inclusion")
public class SpaceFilteringResource {
    private final SpaceFilteringService spaceFilteringService;

    @Inject
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public SpaceFilteringResource(SpaceFilteringService spaceFilteringService) {
        this.spaceFilteringService = spaceFilteringService;
    }

    @Operation(summary="Get the allow list for spaces", description="Returns the allow list for spaces. This list defines which spaces are allowed to synchronise with Rovo")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Allow list for spaces", representation=SpacesFilterModel.class), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have required permissions", restError=true)})
    @GET
    @Path(value="/filter")
    @ScopesAllowed(requiredScope={"READ_ALL"})
    @RateLimited
    public Response getSpacesFilter() {
        SpacesFilterModel model = this.spaceFilteringService.getAllowList().map(allowList -> {
            SpacesFilterModel m = new SpacesFilterModel();
            m.setOptInNewSpaces(allowList.isOptInNewSpaces());
            m.setSpaceReferences(allowList.getSpaces());
            return m;
        }).orElseGet(SpacesFilterModel::new);
        return Response.status((int)200).entity((Object)model).build();
    }

    @Operation(summary="Update space exclusions list (by space keys)", description="Performs an update of the list of the space exclusions. IMPORTANT: this API does not verify if the space key exists")
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Returned if operation is successful"), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have required permissions", restError=true)})
    @PUT
    @Path(value="/keys")
    @ScopesAllowed(requiredScope={"MANAGE_SUBSCRIPTIONS"})
    @RateLimited
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Response setSpaceFilteringSettings(SpaceFilteringByKeysRequest request) {
        try {
            if (request.getSpaceKeys() == null && request.getOptInNewSpaces() == null) {
                this.spaceFilteringService.resetFiltering(request.getSource());
            } else {
                this.validate(request);
                this.spaceFilteringService.setFilteringSettings(request.getSpaceKeys(), request.getOptInNewSpaces() == null || request.getOptInNewSpaces() != false, request.getSource());
            }
        }
        catch (RequestValidationException e) {
            return Response.status((int)400).entity((Object)SpaceFilteringValidationErrorResponse.from(e)).build();
        }
        return Response.noContent().build();
    }

    @Operation(summary="Update space exclusions list (by space IDs)", description="Performs an update of the list of the space exclusions, using space IDs to identify spaces")
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Returned if operation is successful"), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have required permissions", restError=true), @ResponseDoc(responseCode=406, documentation="Returned IDs parsing produces NumberFormatException", restError=true), @ResponseDoc(responseCode=412, documentation="Returned if the space(s) with the given id(s) is (are) not found", representation=MissingSpaceIdsResponse.class, restError=true)})
    @PUT
    @Path(value="/ids")
    @ScopesAllowed(requiredScope={"MANAGE_SUBSCRIPTIONS"})
    @RateLimited
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Response setSpaceFilteringSettings(SpaceFilteringByIdsRequest request) {
        try {
            if (request.getSpaceIds() == null && request.getOptInNewSpaces() == null) {
                this.spaceFilteringService.resetFiltering(request.getSource());
            } else {
                this.validate(request);
                this.spaceFilteringService.setFilteringSettingsByIds((Collection)request.getSpaceIds().stream().map(Long::parseLong).collect(Collectors.toSet()), request.getOptInNewSpaces() == null || request.getOptInNewSpaces() != false, request.getSource());
            }
            return Response.noContent().build();
        }
        catch (NumberFormatException nfe) {
            return Response.status((int)406).build();
        }
        catch (RequestValidationException rve) {
            return Response.status((int)400).entity((Object)SpaceFilteringValidationErrorResponse.from(rve)).build();
        }
        catch (IdsNotFoundException infe) {
            return Response.status((int)412).entity((Object)new MissingSpaceIdsResponse(infe.getMissedIds())).build();
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void validate(SpaceFilteringByIdsRequest request) {
        if (request.getSpaceIds() == null) {
            throw new RequestValidationException(104, "List of space IDs is required");
        }
        if (request.getSource() == null || request.getSource().trim().isEmpty()) {
            throw new RequestValidationException(105, "Source is required");
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void validate(SpaceFilteringByKeysRequest request) {
        if (request.getSpaceKeys() == null) {
            throw new RequestValidationException(101, "List of space keys is required");
        }
        if (request.getSource() == null || request.getSource().trim().isEmpty()) {
            throw new RequestValidationException(105, "Source is required");
        }
        for (String key : request.getSpaceKeys()) {
            if (key == null) {
                throw new RequestValidationException(102, "Space key cannot be NULL");
            }
            if (key.length() <= 255) continue;
            throw new RequestValidationException(103, "Space key length exceeds 255 characters");
        }
    }
}

