/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl;

import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.impl.service.content.factory.SpaceFactory;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.core.ApiRestEntityFactory;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.rest.serialization.jackson2.enrich.RestEntityEnrichmentManager;
import com.atlassian.confluence.rest.serialization.jackson2.enrich.SchemaType;
import com.atlassian.confluence.rest.v2.api.model.RestEntity;
import com.atlassian.confluence.spaces.Space;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultApiRestEntityFactory
implements ApiRestEntityFactory {
    private final ContentFactory contentFactory;
    private final SpaceFactory spaceFactory;
    private final RestEntityEnrichmentManager restEntityEnrichmentManager;

    public DefaultApiRestEntityFactory(ContentFactory contentFactory, SpaceFactory spaceFactory, RestEntityEnrichmentManager restEntityEnrichmentManager) {
        this.contentFactory = contentFactory;
        this.spaceFactory = spaceFactory;
        this.restEntityEnrichmentManager = restEntityEnrichmentManager;
    }

    public RestEntity buildRestEntityFrom(ContentEntityObject entity, Expansions expansions) {
        return this.enrichOrThrow(this.contentFactory.buildFrom(entity, expansions));
    }

    public RestEntity<com.atlassian.confluence.api.model.content.Space> buildRestEntityFrom(Space space, Expansions expansions) {
        return this.enrichOrThrow(this.spaceFactory.buildFrom(space, expansions));
    }

    public Iterable<RestEntity> buildRestEntityFromContent(Iterable<? extends ContentEntityObject> entities, Expansions expansions) {
        return this.enrichIterable(this.contentFactory.buildFrom(entities, expansions));
    }

    public Iterable<RestEntity> buildRestEntityFromSpaces(Iterable<Space> spaces, Expansions expansions) {
        return this.enrichIterable(this.spaceFactory.buildFrom(spaces, expansions));
    }

    public boolean isEnrichableList(Class listType) {
        return this.restEntityEnrichmentManager.isEnrichableList(listType);
    }

    public boolean isEnrichableEntity(Class entityType) {
        return this.restEntityEnrichmentManager.isEnrichableEntity(entityType);
    }

    public @NonNull Map<String, Type> getEnrichedPropertyTypes(Type type, boolean root) {
        return this.restEntityEnrichmentManager.getEnrichedPropertyTypes(type, root);
    }

    public Object convertAndEnrich(Object entity, ApiRestEntityFactory.SchemaType schemaType) {
        return this.restEntityEnrichmentManager.convertAndEnrich(entity, DefaultApiRestEntityFactory.convert(schemaType));
    }

    private <T> RestEntity<T> enrichOrThrow(T content) {
        Object obj = this.convertAndEnrich(content, ApiRestEntityFactory.SchemaType.REST);
        if (!(obj instanceof RestEntity)) {
            throw new IllegalArgumentException("Entity was not converted to RestEntity got : " + String.valueOf(obj));
        }
        return (RestEntity)obj;
    }

    private static SchemaType convert(ApiRestEntityFactory.SchemaType schemaType) {
        return switch (schemaType) {
            default -> throw new MatchException(null, null);
            case ApiRestEntityFactory.SchemaType.REST -> SchemaType.REST;
            case ApiRestEntityFactory.SchemaType.GRAPHQL -> SchemaType.GRAPHQL;
        };
    }

    private <T> Iterable<RestEntity> enrichIterable(Iterable<T> modelEntities) {
        return ImmutableList.copyOf(modelEntities).stream().map(this::enrichOrThrow).collect(Collectors.toList());
    }
}

