/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.sal;

import com.atlassian.confluence.cluster.ClusterConfigurationHelper;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ConfluenceApplicationProperties
implements ApplicationProperties {
    private final GlobalSettingsManager settingsManager;
    private final ClusterConfigurationHelper clusterConfigurationHelper;
    private final FilesystemPath sharedHome;
    private final FilesystemPath localHome;
    private final FilesystemPath confluenceHome;
    private final HttpContext httpContext;
    private final Supplier<String> CANONICAL_BASE_URL_SUPPLIER = this::getCanonicalBaseUrl;
    private final Supplier<String> CANONICAL_CONTEXT_PATH_SUPPLIER = this::getCanonicalContextPath;

    public ConfluenceApplicationProperties(GlobalSettingsManager settingsManager, ClusterConfigurationHelper clusterConfigurationHelper, HttpContext httpContext, FilesystemPath sharedHome, FilesystemPath localHome, FilesystemPath confluenceHome) {
        this.settingsManager = settingsManager;
        this.clusterConfigurationHelper = clusterConfigurationHelper;
        this.httpContext = httpContext;
        this.sharedHome = sharedHome;
        this.localHome = localHome;
        this.confluenceHome = confluenceHome;
    }

    public String getBaseUrl() {
        return this.getCanonicalBaseUrl();
    }

    public String getBaseUrl(UrlMode urlMode) {
        return switch (urlMode) {
            default -> throw new MatchException(null, null);
            case UrlMode.CANONICAL -> this.getCanonicalBaseUrl();
            case UrlMode.ABSOLUTE -> this.getBaseUrlFromRequest(this.httpContext.getActiveRequest()).orElseGet(this.CANONICAL_BASE_URL_SUPPLIER);
            case UrlMode.RELATIVE -> this.getContextPathFromRequest(this.httpContext.getActiveRequest()).orElseGet(this.CANONICAL_CONTEXT_PATH_SUPPLIER);
            case UrlMode.RELATIVE_CANONICAL -> this.getCanonicalContextPath();
            case UrlMode.AUTO -> this.getContextPathFromRequest(this.httpContext.getActiveRequest()).orElseGet(this.CANONICAL_BASE_URL_SUPPLIER);
        };
    }

    protected String getCanonicalBaseUrl() {
        if (this.settingsManager == null) {
            return this.getBaseUrlFromRequest(this.httpContext.getActiveRequest()).orElseThrow(() -> new IllegalStateException("Unable to determine Base URL from request"));
        }
        return this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    private String getCanonicalContextPath() {
        String baseUrl = this.getCanonicalBaseUrl();
        try {
            return new URL(baseUrl).getPath();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Base URL misconfigured: " + (String)(baseUrl == null ? "<null>" : "'" + baseUrl + "'"), e);
        }
    }

    protected Optional<String> getBaseUrlFromRequest(HttpServletRequest request) {
        if (request != null) {
            return Optional.of(GeneralUtil.lookupDomainName((HttpServletRequest)request));
        }
        return Optional.empty();
    }

    private Optional<String> getContextPathFromRequest(HttpServletRequest request) {
        if (request != null) {
            return Optional.of(request.getContextPath());
        }
        return Optional.empty();
    }

    public String getDisplayName() {
        return "Confluence";
    }

    public String getVersion() {
        return GeneralUtil.getVersionNumber();
    }

    public Date getBuildDate() {
        return BuildInformation.INSTANCE.getBuildDate();
    }

    public String getBuildNumber() {
        return BuildInformation.INSTANCE.getMarketplaceBuildNumber();
    }

    public File getHomeDirectory() {
        return this.confluenceHome.asJavaFile();
    }

    public @NonNull Optional<Path> getLocalHomeDirectory() {
        return Optional.of(this.localHome.asJavaPath());
    }

    public @NonNull Optional<Path> getSharedHomeDirectory() {
        return this.clusterConfigurationHelper.isClusterHomeConfigured() ? Optional.of(this.sharedHome.asJavaPath()) : Optional.empty();
    }

    public String getPropertyValue(String key) {
        throw new UnsupportedOperationException("Confluence does not support retrieving generic property values");
    }

    public String getApplicationName() {
        return this.getDisplayName();
    }

    public @NonNull String getPlatformId() {
        return "conf";
    }

    public @NonNull String getApplicationFileEncoding() {
        return Optional.ofNullable(this.settingsManager).map(GlobalSettingsManager::getGlobalSettings).map(Settings::getDefaultEncoding).orElse(StandardCharsets.UTF_8.name());
    }
}

