/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.sal;

import com.atlassian.bandana.dmz.BandanaManagerInternal;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.api.impl.sal.ConfluenceApplicationProperties;
import com.atlassian.confluence.api.impl.sal.ConfluenceDarkFeatureManager;
import com.atlassian.confluence.api.impl.sal.ConfluenceHttpClientRequestFactory;
import com.atlassian.confluence.api.impl.sal.rdbms.ConfluenceConnectionProvider;
import com.atlassian.confluence.api.impl.sal.timezone.ConfluenceTimeZoneManager;
import com.atlassian.confluence.api.impl.sal.user.ConfluenceUserSettingsService;
import com.atlassian.confluence.api.impl.service.settings.ConfluencePluginSettingsFactory;
import com.atlassian.confluence.api.service.settings.ExtendedPluginSettingsFactory;
import com.atlassian.confluence.cluster.ClusterConfigurationHelper;
import com.atlassian.confluence.impl.plugin.settings.PluginSettingRepository;
import com.atlassian.confluence.impl.user.preferences.dao.UserPreferencesDao;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spring.transaction.interceptor.ConfluenceSpringHostContextAccessor;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import com.atlassian.confluence.upgrade.BuildNumberComparator;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.atlassian.confluence.user.UserPreferencesAccessor;
import com.atlassian.confluence.util.BooleanFuse;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.net.NonMarshallingRequestFactory;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.core.rdbms.DefaultTransactionalExecutorFactory;
import com.atlassian.sal.core.transaction.HostContextTransactionTemplate;
import com.atlassian.sal.spi.HostConnectionAccessor;
import com.atlassian.sal.spi.HostContextAccessor;
import com.atlassian.sal.spring.connection.SpringHostConnectionAccessor;
import java.util.function.BooleanSupplier;
import org.hibernate.SessionFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
class SalBeans {
    SalBeans() {
    }

    @AvailableToPlugins
    @Bean
    ConfluenceApplicationProperties applicationProperties(GlobalSettingsManager globalSettingsManager, ClusterConfigurationHelper clusterConfigurationHelper, HttpContext httpContext, @Qualifier(value="sharedHome") FilesystemPath sharedHome, @Qualifier(value="localHome") FilesystemPath localHome, @Qualifier(value="confluenceHome") FilesystemPath confluenceHome) {
        return new ConfluenceApplicationProperties(globalSettingsManager, clusterConfigurationHelper, httpContext, sharedHome, localHome, confluenceHome);
    }

    @AvailableToPlugins
    @Bean
    ConfluenceDarkFeatureManager salDarkFeatureManager(DarkFeaturesManager darkFeaturesManager, ConfluenceUserResolver confluenceUserResolver, PermissionManager permissionManager) {
        return new ConfluenceDarkFeatureManager(darkFeaturesManager, confluenceUserResolver, permissionManager);
    }

    @AvailableToPlugins
    @Bean
    ConfluenceTimeZoneManager timeZoneManager(ConfluenceUserResolver confluenceUserResolver, UserPreferencesAccessor userPreferencesAccessor, GlobalSettingsManager globalSettingsManager) {
        return new ConfluenceTimeZoneManager(confluenceUserResolver, userPreferencesAccessor, globalSettingsManager);
    }

    @AvailableToPlugins(interfaces={RequestFactory.class, NonMarshallingRequestFactory.class})
    @Bean
    ConfluenceHttpClientRequestFactory requestFactory(GlobalSettingsManager globalSettingsManager, @Qualifier(value="httpClientRequestClassLoaderAdvisor") Advisor classLoaderAdvisor, PluginSettingsFactory pluginSettingsFactory) {
        return new ConfluenceHttpClientRequestFactory(globalSettingsManager, classLoaderAdvisor, pluginSettingsFactory);
    }

    @AvailableToPlugins(value=TransactionTemplate.class)
    @Bean
    HostContextTransactionTemplate transactionTemplate(HostContextAccessor hostContextAccessor) {
        return new HostContextTransactionTemplate(hostContextAccessor);
    }

    @AvailableToPlugins(value=TransactionalExecutorFactory.class)
    @Bean
    DefaultTransactionalExecutorFactory salTransactionalExecutorFactory(HostConnectionAccessor salHostConnnectionAccessor) {
        return new DefaultTransactionalExecutorFactory(salHostConnnectionAccessor);
    }

    @AvailableToPlugins(interfaces={HostContextAccessor.class, TransactionalHostContextAccessor.class})
    @Bean
    ConfluenceSpringHostContextAccessor hostContextAccessor(PlatformTransactionManager transactionManager) {
        return new ConfluenceSpringHostContextAccessor(transactionManager);
    }

    @Bean
    ConfluenceConnectionProvider salConnectionProvider(SessionFactory sessionFactory) {
        return new ConfluenceConnectionProvider(sessionFactory);
    }

    @Bean
    SpringHostConnectionAccessor salHostConnnectionAccessor(ConfluenceConnectionProvider salConnectionProvider, PlatformTransactionManager transactionManager) {
        return new SpringHostConnectionAccessor((SpringHostConnectionAccessor.ConnectionProvider)salConnectionProvider, transactionManager);
    }

    @AvailableToPlugins
    @DependsOn(value={"annotationTransactionInterceptor"})
    @Bean
    FactoryBean<ConfluenceUserSettingsService> userSettingsService(UserPreferencesDao userPreferencesDao, ConfluenceUserResolver confluenceUserResolver) {
        ProxyFactoryBean proxyFactoryBean = new ProxyFactoryBean();
        proxyFactoryBean.setTarget((Object)new ConfluenceUserSettingsService(userPreferencesDao, confluenceUserResolver));
        proxyFactoryBean.setInterceptorNames(new String[]{"annotationTransactionInterceptor"});
        return proxyFactoryBean;
    }

    @AvailableToPlugins(interfaces={ExtendedPluginSettingsFactory.class, PluginSettingsFactory.class})
    @Bean
    ConfluencePluginSettingsFactory pluginSettingsFactory(PluginSettingRepository pluginSettingRepository, BandanaManagerInternal bandanaManager, @Qualifier(value="isPluginSettingsCreatedRef") BooleanSupplier isPluginSettingsCreatedRef) {
        return new ConfluencePluginSettingsFactory(pluginSettingRepository, bandanaManager, isPluginSettingsCreatedRef);
    }

    @Bean(value={"isPluginSettingsCreatedRef"})
    BooleanSupplier isPluginSettingsCreatedRef(ApplicationConfiguration applicationConfig) {
        return new BooleanFuse(false, () -> new BuildNumberComparator().compare(applicationConfig.getBuildNumber(), "9301") >= 0);
    }
}

