/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.sal.user;

import com.atlassian.confluence.impl.user.preferences.dao.UserPreference;
import com.atlassian.confluence.impl.user.preferences.dao.UserPreferencesDao;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.sal.core.usersettings.DefaultUserSettings;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ConfluenceUserSettingsService
implements UserSettingsService {
    private final UserPreferencesDao userPreferencesDao;
    private final ConfluenceUserResolver userResolver;

    public ConfluenceUserSettingsService(UserPreferencesDao userPreferencesDao, ConfluenceUserResolver userResolver) {
        this.userPreferencesDao = userPreferencesDao;
        this.userResolver = userResolver;
    }

    @Transactional(readOnly=true)
    public UserSettings getUserSettings(UserKey userKey) {
        this.assertValid(userKey);
        return this.createBuilder(this.userPreferencesDao.getUserPreferences(userKey)).build();
    }

    public void updateUserSettings(UserKey userKey, Function<UserSettingsBuilder, UserSettings> updateFunction) {
        this.assertValid(userKey);
        List existingPreferences = this.userPreferencesDao.getUserPreferences(userKey);
        UserSettingsBuilder builder = this.createBuilder(existingPreferences);
        Set existingKeys = Set.copyOf(builder.getKeys());
        UserSettings newSettings = updateFunction.apply(builder);
        newSettings.getKeys().forEach(key -> this.setValue(userKey, (String)key, newSettings));
        existingKeys.stream().filter(key -> !newSettings.getKeys().contains(key)).forEach(key -> this.userPreferencesDao.removeUserPreference(userKey, ConfluenceUserSettingsService.prefixedKey(key)));
    }

    private void setValue(UserKey userKey, String key, UserSettings userSettings) {
        String prefixedKey = "sal_" + ConfluenceUserSettingsService.validateKey(key);
        userSettings.getString(key).toOptional().ifPresent(stringVal -> this.userPreferencesDao.setUserPreference(userKey, prefixedKey, ConfluenceUserSettingsService.validateValue(stringVal)));
        userSettings.getBoolean(key).toOptional().ifPresent(booleanVal -> this.userPreferencesDao.setUserPreference(userKey, prefixedKey, booleanVal.booleanValue()));
        userSettings.getLong(key).toOptional().ifPresent(longVal -> this.userPreferencesDao.setUserPreference(userKey, prefixedKey, longVal.longValue()));
    }

    private void assertValid(UserKey userKey) {
        if (userKey == null || this.userResolver.getExistingUserByKey(userKey) == null) {
            throw new IllegalArgumentException();
        }
    }

    private UserSettingsBuilder createBuilder(Iterable<UserPreference> items) {
        UserSettingsBuilder builder = DefaultUserSettings.builder();
        items.forEach(item -> ConfluenceUserSettingsService.stripPrefix(item.key()).ifPresent(key -> {
            switch (item.valueType()) {
                case STRING: {
                    builder.put(key, item.stringValue());
                    break;
                }
                case LONG: {
                    builder.put(key, item.longValue().longValue());
                    break;
                }
                case BOOLEAN: {
                    builder.put(key, item.booleanValue().booleanValue());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }));
        return builder;
    }

    private static String prefixedKey(String key) {
        return "sal_" + ConfluenceUserSettingsService.validateKey(key);
    }

    private static Optional<String> stripPrefix(String key) {
        if (StringUtils.startsWith((CharSequence)key, (CharSequence)"sal_")) {
            return Optional.of(StringUtils.removeStart((String)key, (String)"sal_"));
        }
        return Optional.empty();
    }

    private static String validateKey(String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        Preconditions.checkArgument((key.length() <= MAX_KEY_LENGTH ? 1 : 0) != 0, (String)"key cannot be longer than %s characters", (int)MAX_KEY_LENGTH);
        return key;
    }

    private static String validateValue(String value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value cannot be null");
        Preconditions.checkArgument((value.length() <= 255 ? 1 : 0) != 0, (String)"value cannot be longer than %s characters", (int)255);
        return value;
    }
}

