/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.colorscheme;

import com.atlassian.confluence.api.colorscheme.ColorSchemeModel;
import com.atlassian.confluence.api.colorscheme.ColorSchemeThemeBasedModel;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.themes.BaseColourScheme;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.util.ColourUtils;

public class ColorSchemeHelper {
    public static BaseColourScheme convertColorSchemeThemeBasedModelToColorScheme(ColorSchemeThemeBasedModel colorSchemeModel) {
        BaseColourScheme newColorScheme = new BaseColourScheme();
        ColorSchemeHelper.convertLightThemeColorModelToColorScheme(colorSchemeModel.getColorSchemeModelLight(), newColorScheme);
        ColorSchemeHelper.convertDarkThemeColorModelToColorScheme(colorSchemeModel.getColorSchemeModelDark(), newColorScheme);
        return newColorScheme;
    }

    public static void convertLightThemeColorModelToColorScheme(ColorSchemeModel colorSchemeModel, BaseColourScheme newColorScheme) {
        newColorScheme.set("property.style.topbarcolour", colorSchemeModel.getTopBarColor().trim());
        newColorScheme.set("property.style.topbarmenuselectedbgcolour", colorSchemeModel.getTopBarMenuSelectedBgColor().trim());
        newColorScheme.set("property.style.topbarmenuselectedtextcolour", colorSchemeModel.getTopBarMenuSelectedTextColor().trim());
        newColorScheme.set("property.style.breadcrumbstextcolour", colorSchemeModel.getBreadcrumbsTextColor().trim());
        newColorScheme.set("property.style.headerbuttonbasebgcolour", colorSchemeModel.getHeaderButtonBgColor().trim());
        newColorScheme.set("property.style.headerbuttontextcolour", colorSchemeModel.getHeaderButtonTextColor().trim());
        newColorScheme.set("property.style.searchfieldtextcolour", colorSchemeModel.getSearchFieldTextColor().trim());
        newColorScheme.set("property.style.searchfieldbgcolour", colorSchemeModel.getSearchFieldBgColor().trim());
        newColorScheme.set("property.style.menuitemselectedbgcolour", colorSchemeModel.getMenuItemSelectedBgColor().trim());
        newColorScheme.set("property.style.menuitemselectedtextcolour", colorSchemeModel.getMenuItemSelectedTextColor().trim());
        newColorScheme.set("property.style.menuitemtextcolour", colorSchemeModel.getMenuItemTextColor().trim());
        newColorScheme.set("property.style.headingtextcolour", colorSchemeModel.getHeadingTextColor().trim());
        newColorScheme.set("property.style.linkcolour", colorSchemeModel.getLinkColor().trim());
    }

    public static void convertDarkThemeColorModelToColorScheme(ColorSchemeModel colorSchemeModel, BaseColourScheme newColorScheme) {
        newColorScheme.set("property.style.topbarcolour.dark", colorSchemeModel.getTopBarColor().trim());
        newColorScheme.set("property.style.topbarmenuselectedbgcolour.dark", colorSchemeModel.getTopBarMenuSelectedBgColor().trim());
        newColorScheme.set("property.style.topbarmenuselectedtextcolour.dark", colorSchemeModel.getTopBarMenuSelectedTextColor().trim());
        newColorScheme.set("property.style.breadcrumbstextcolour.dark", colorSchemeModel.getBreadcrumbsTextColor().trim());
        newColorScheme.set("property.style.headerbuttonbasebgcolour.dark", colorSchemeModel.getHeaderButtonBgColor().trim());
        newColorScheme.set("property.style.headerbuttontextcolour.dark", colorSchemeModel.getHeaderButtonTextColor().trim());
        newColorScheme.set("property.style.searchfieldtextcolour.dark", colorSchemeModel.getSearchFieldTextColor().trim());
        newColorScheme.set("property.style.searchfieldbgcolour.dark", colorSchemeModel.getSearchFieldBgColor().trim());
        newColorScheme.set("property.style.menuitemselectedbgcolour.dark", colorSchemeModel.getMenuItemSelectedBgColor().trim());
        newColorScheme.set("property.style.menuitemselectedtextcolour.dark", colorSchemeModel.getMenuItemSelectedTextColor().trim());
        newColorScheme.set("property.style.menuitemtextcolour.dark", colorSchemeModel.getMenuItemTextColor().trim());
        newColorScheme.set("property.style.headingtextcolour.dark", colorSchemeModel.getHeadingTextColor().trim());
        newColorScheme.set("property.style.linkcolour.dark", colorSchemeModel.getLinkColor().trim());
    }

    public static ColorSchemeThemeBasedModel convertColorSchemeToThemeBasedColorSchemeModel(ColourScheme colorScheme) {
        return new ColorSchemeThemeBasedModel(ColorSchemeHelper.convertColorSchemeToColorSchemeModelForLightTheme(colorScheme), ColorSchemeHelper.convertColorSchemeToColorSchemeModelForDarkTheme(colorScheme));
    }

    public static ColorSchemeModel convertColorSchemeToColorSchemeModelForLightTheme(ColourScheme colorScheme) {
        return new ColorSchemeModel(colorScheme.get("property.style.topbarcolour"), colorScheme.get("property.style.topbarmenuselectedbgcolour"), colorScheme.get("property.style.topbarmenuselectedtextcolour"), colorScheme.get("property.style.breadcrumbstextcolour"), colorScheme.get("property.style.headerbuttonbasebgcolour"), colorScheme.get("property.style.headerbuttontextcolour"), colorScheme.get("property.style.searchfieldtextcolour"), colorScheme.get("property.style.searchfieldbgcolour"), colorScheme.get("property.style.menuitemselectedbgcolour"), colorScheme.get("property.style.menuitemselectedtextcolour"), colorScheme.get("property.style.menuitemtextcolour"), colorScheme.get("property.style.headingtextcolour"), colorScheme.get("property.style.linkcolour"));
    }

    public static ColorSchemeModel convertColorSchemeToColorSchemeModelForDarkTheme(ColourScheme colorScheme) {
        return new ColorSchemeModel(colorScheme.get("property.style.topbarcolour.dark"), colorScheme.get("property.style.topbarmenuselectedbgcolour.dark"), colorScheme.get("property.style.topbarmenuselectedtextcolour.dark"), colorScheme.get("property.style.breadcrumbstextcolour.dark"), colorScheme.get("property.style.headerbuttonbasebgcolour.dark"), colorScheme.get("property.style.headerbuttontextcolour.dark"), colorScheme.get("property.style.searchfieldtextcolour.dark"), colorScheme.get("property.style.searchfieldbgcolour.dark"), colorScheme.get("property.style.menuitemselectedbgcolour.dark"), colorScheme.get("property.style.menuitemselectedtextcolour.dark"), colorScheme.get("property.style.menuitemtextcolour.dark"), colorScheme.get("property.style.headingtextcolour.dark"), colorScheme.get("property.style.linkcolour.dark"));
    }

    public static void isValidThemeBasedScheme(ColorSchemeThemeBasedModel colorSchemeThemeBasedModel) {
        ColorSchemeHelper.isColorSchemeValid(colorSchemeThemeBasedModel.getColorSchemeModelDark());
        ColorSchemeHelper.isColorSchemeValid(colorSchemeThemeBasedModel.getColorSchemeModelLight());
    }

    public static void isColorSchemeValid(ColorSchemeModel colorSchemeModel) {
        ColorSchemeHelper.isColorValid(colorSchemeModel.getTopBarColor());
        ColorSchemeHelper.isColorValid(colorSchemeModel.getTopBarMenuSelectedBgColor());
        ColorSchemeHelper.isColorValid(colorSchemeModel.getTopBarMenuSelectedTextColor());
        ColorSchemeHelper.isColorValid(colorSchemeModel.getBreadcrumbsTextColor());
        ColorSchemeHelper.isColorValid(colorSchemeModel.getHeaderButtonBgColor());
        ColorSchemeHelper.isColorValid(colorSchemeModel.getHeaderButtonTextColor());
        ColorSchemeHelper.isColorValid(colorSchemeModel.getSearchFieldBgColor());
        ColorSchemeHelper.isColorValid(colorSchemeModel.getSearchFieldTextColor());
        ColorSchemeHelper.isColorValid(colorSchemeModel.getMenuItemSelectedBgColor());
        ColorSchemeHelper.isColorValid(colorSchemeModel.getMenuItemSelectedTextColor());
        ColorSchemeHelper.isColorValid(colorSchemeModel.getMenuItemTextColor());
        ColorSchemeHelper.isColorValid(colorSchemeModel.getHeadingTextColor());
        ColorSchemeHelper.isColorValid(colorSchemeModel.getLinkColor());
    }

    private static void isColorValid(String color) {
        if (!ColourUtils.isValidColor((String)color)) {
            throw new BadRequestException("Invalid color in the color scheme");
        }
    }
}

