/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.colorscheme;

import com.atlassian.confluence.api.colorscheme.ColorSchemeThemeBasedModel;
import com.atlassian.confluence.api.impl.service.colorscheme.ColorSchemeHelper;
import com.atlassian.confluence.api.model.messages.Message;
import com.atlassian.confluence.api.model.messages.SimpleMessage;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.colorscheme.GlobalColorSchemeService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.themes.BaseColourScheme;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;

public class GlobalColorSchemeServiceImpl
implements GlobalColorSchemeService {
    private final ColourSchemeManager colourSchemeManager;
    private final PermissionManager permissionManager;

    public GlobalColorSchemeServiceImpl(ColourSchemeManager colourSchemeManager, PermissionManager permissionManager) {
        this.colourSchemeManager = colourSchemeManager;
        this.permissionManager = permissionManager;
    }

    public ColorSchemeThemeBasedModel getColorScheme() {
        ColourScheme colorScheme = this.colourSchemeManager.getGlobalColourScheme();
        return ColorSchemeHelper.convertColorSchemeToThemeBasedColorSchemeModel(colorScheme);
    }

    public ColorSchemeThemeBasedModel getDefaultColorScheme() {
        ColourScheme defaultColourScheme = this.colourSchemeManager.getDefaultColourScheme();
        return ColorSchemeHelper.convertColorSchemeToThemeBasedColorSchemeModel(defaultColourScheme);
    }

    public void setColorScheme(ColorSchemeThemeBasedModel colorScheme) {
        ColorSchemeHelper.isValidThemeBasedScheme(colorScheme);
        this.validator().validateUpdate().throwIfNotSuccessful();
        BaseColourScheme newColorScheme = ColorSchemeHelper.convertColorSchemeThemeBasedModelToColorScheme(colorScheme);
        this.colourSchemeManager.saveGlobalColourScheme(newColorScheme);
    }

    public void resetColorScheme() {
        this.validator().validateUpdate().throwIfNotSuccessful();
        this.colourSchemeManager.resetColourScheme(null);
    }

    public GlobalColorSchemeService.Validator validator() {
        return new ValidatorImpl();
    }

    public class ValidatorImpl
    implements GlobalColorSchemeService.Validator {
        public ValidationResult validateUpdate() {
            if (!GlobalColorSchemeServiceImpl.this.permissionManager.isConfluenceAdministrator(AuthenticatedUserThreadLocal.get())) {
                return SimpleValidationResult.builder().addMessage((Message)SimpleMessage.withTranslation((String)"Not permitted to update global color scheme")).withExceptionSupplier(ServiceExceptionSupplier.permissionExceptionExceptionSupplier()).build();
            }
            return SimpleValidationResult.VALID;
        }
    }
}

