/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.colorscheme;

import com.atlassian.confluence.api.colorscheme.ColorSchemeThemeBasedModel;
import com.atlassian.confluence.api.colorscheme.SpaceColorSchemeTypeModel;
import com.atlassian.confluence.api.impl.service.colorscheme.ColorSchemeHelper;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.messages.Message;
import com.atlassian.confluence.api.model.messages.SimpleMessage;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.colorscheme.SpaceColorSchemeService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.BaseColourScheme;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.confluence.util.LayoutHelper;

public class SpaceColorSchemeServiceImpl
implements SpaceColorSchemeService {
    private final ColourSchemeManager colourSchemeManager;
    private final SpaceService spaceService;
    private final SpaceService.Validator spaceValidator;

    public SpaceColorSchemeServiceImpl(ColourSchemeManager colourSchemeManager, SpaceService spaceService, SpaceService.Validator spaceValidator) {
        this.colourSchemeManager = colourSchemeManager;
        this.spaceService = spaceService;
        this.spaceValidator = spaceValidator;
    }

    public ColorSchemeThemeBasedModel getSpaceColorScheme(String spaceKey) {
        this.validator().validateView(spaceKey).throwIfNotSuccessful();
        BaseColourScheme colorScheme = this.colourSchemeManager.getSpaceColourSchemeIsolated(spaceKey);
        if (colorScheme != null) {
            return ColorSchemeHelper.convertColorSchemeToThemeBasedColorSchemeModel((ColourScheme)colorScheme);
        }
        throw new NotFoundException("Color Scheme for " + spaceKey + " not found");
    }

    public void setSpaceColorScheme(String spaceKey, ColorSchemeThemeBasedModel colorScheme) {
        this.validator().validateUpdate(spaceKey).throwIfNotSuccessful();
        ColorSchemeHelper.isValidThemeBasedScheme(colorScheme);
        BaseColourScheme newColorScheme = ColorSchemeHelper.convertColorSchemeThemeBasedModelToColorScheme(colorScheme);
        this.colourSchemeManager.saveSpaceColourScheme(new Space(spaceKey), newColorScheme);
    }

    public SpaceColorSchemeTypeModel getColorSchemeTypeForSpace(String spaceKey) {
        this.validator().validateUpdate(spaceKey).throwIfNotSuccessful();
        return new SpaceColorSchemeTypeModel(this.colourSchemeManager.getColourSchemeSetting(new Space(spaceKey)));
    }

    public void setColorSchemeTypeForSpace(String spaceKey, SpaceColorSchemeTypeModel colorSchemeType) {
        this.validator().validateUpdate(spaceKey).throwIfNotSuccessful();
        for (String key : LayoutHelper.BUTTON_VALUE_LIST) {
            if (!key.equals(colorSchemeType.getType())) continue;
            this.colourSchemeManager.setColourSchemeSetting(new Space(spaceKey), key);
            return;
        }
        throw new BadRequestException("Invalid value for color scheme type");
    }

    public void resetSpaceColorScheme(String spaceKey) {
        this.validator().validateUpdate(spaceKey).throwIfNotSuccessful();
        this.colourSchemeManager.resetColourScheme(new Space(spaceKey));
    }

    public SpaceColorSchemeService.Validator validator() {
        return new ValidatorImpl();
    }

    public class ValidatorImpl
    implements SpaceColorSchemeService.Validator {
        public ValidationResult validateView(String spaceKey) {
            if (spaceKey == null) {
                return SimpleValidationResult.builder().addMessage((Message)SimpleMessage.withTranslation((String)"Space key missing")).withExceptionSupplier(ServiceExceptionSupplier.badRequestExceptionSupplier()).build();
            }
            SpaceColorSchemeServiceImpl.this.spaceValidator.validateGet(spaceKey).throwIfNotSuccessful();
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateUpdate(String spaceKey) {
            if (spaceKey == null) {
                return SimpleValidationResult.builder().addMessage((Message)SimpleMessage.withTranslation((String)"Space key missing")).withExceptionSupplier(ServiceExceptionSupplier.badRequestExceptionSupplier()).build();
            }
            com.atlassian.confluence.api.model.content.Space spaces = (com.atlassian.confluence.api.model.content.Space)SpaceColorSchemeServiceImpl.this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetch().orElseThrow(NotFoundException::new);
            SpaceColorSchemeServiceImpl.this.spaceValidator.validateUpdate(spaces).throwIfNotSuccessful();
            return SimpleValidationResult.VALID;
        }
    }
}

