/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.AttachmentExtractedTextService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.pages.AttachmentManagerInternal;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.index.attachment.AttachmentExtractedTextManager;
import com.atlassian.confluence.internal.index.attachment.AttachmentExtractedTextHelper;
import com.atlassian.confluence.internal.index.attachment.PluginAttachmentTextExtractorsProvider;
import com.atlassian.confluence.internal.index.attachment.ShouldExtractAttachmentTextPredicate;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentExtractedTextServiceImpl
implements AttachmentExtractedTextService {
    private static final Logger log = LoggerFactory.getLogger(AttachmentExtractedTextServiceImpl.class);
    private final AttachmentManagerInternal attachmentManager;
    private final ContentEntityManager contentEntityManager;
    private final PermissionManager permissionManager;
    private final AttachmentExtractedTextManager attachmentExtractedTextManager;
    private final PluginAttachmentTextExtractorsProvider pluginAttachmentTextExtractorsProvider;
    private final ShouldExtractAttachmentTextPredicate shouldExtractAttachmentTextPredicate;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;

    public AttachmentExtractedTextServiceImpl(AttachmentManagerInternal attachmentManager, ContentEntityManager contentEntityManager, PermissionManager permissionManager, AttachmentExtractedTextManager attachmentExtractedTextManager, PluginAttachmentTextExtractorsProvider pluginAttachmentTextExtractorsProvider, ShouldExtractAttachmentTextPredicate shouldExtractAttachmentTextPredicate, ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        this.attachmentManager = attachmentManager;
        this.contentEntityManager = contentEntityManager;
        this.permissionManager = permissionManager;
        this.attachmentExtractedTextManager = attachmentExtractedTextManager;
        this.pluginAttachmentTextExtractorsProvider = pluginAttachmentTextExtractorsProvider;
        this.shouldExtractAttachmentTextPredicate = shouldExtractAttachmentTextPredicate;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
    }

    public Optional<String> extractedText(ContentId contentId, ContentId attachmentId, long limit) throws ServiceException {
        StringBuilder resultBuilder = new StringBuilder();
        if (!this.hasExtractedText(contentId, attachmentId)) {
            return Optional.empty();
        }
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId.asLong());
        Optional extracted = this.attachmentExtractedTextManager.getContent(attachment);
        log.debug("Extracted text of {} is available, reuse it", (Object)attachment.getId());
        if (extracted.flatMap(AttachmentExtractedTextHelper::toString).isEmpty()) {
            return Optional.empty();
        }
        extracted.flatMap(AttachmentExtractedTextHelper::toString).ifPresent(resultBuilder::append);
        return Optional.of(resultBuilder.substring(0, (int)Math.min((long)resultBuilder.length(), limit)));
    }

    public boolean hasExtractedText(ContentId contentId, ContentId attachmentId) throws ServiceException {
        Attachment attachment;
        if (contentId == null || attachmentId == null) {
            throw new BadRequestException("contentId and attachmentId must not be null");
        }
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(contentId.asLong());
        try {
            attachment = this.attachmentManager.getAttachment(attachmentId.asLong());
        }
        catch (Exception e) {
            throw new NotFoundException("Cannot retrieve attachment");
        }
        if (contentEntityObject == null || attachment == null) {
            throw new NotFoundException("Content or attachment not found");
        }
        ContentEntityObject container = attachment.getContainer();
        if (!attachment.isCurrent() || container == null || !container.getContentId().equals((Object)contentId)) {
            throw new BadRequestException("Attachment or container is not correct");
        }
        if (!this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL") && !this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)attachment)) {
            throw new PermissionException("Don't have permission to view attachment");
        }
        if (!this.shouldExtract(attachment)) {
            return false;
        }
        Optional extracted = this.attachmentExtractedTextManager.getContent(attachment);
        return extracted.isPresent();
    }

    private boolean shouldExtract(Attachment attachment) {
        return this.pluginAttachmentTextExtractorsProvider.get().anyMatch(attachmentTextExtractor -> this.shouldExtractAttachmentTextPredicate.test(attachmentTextExtractor, attachment));
    }
}

