/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content;

import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.impl.service.content.finder.ContentFinderFactory;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.messages.Message;
import com.atlassian.confluence.api.model.messages.SimpleMessage;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.content.ContentTrashService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ConflictException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.content.apisupport.ApiSupportProvider;
import com.atlassian.confluence.content.apisupport.ContentTypeApiSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.ContentEntityManagerInternal;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.pages.ContentConvertible;
import com.atlassian.confluence.persistence.RetryableTransaction;
import com.atlassian.confluence.relations.touch.TouchRelationSupport;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.UserChecker;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ContentServiceImpl
implements ContentService {
    static final ImmutableSet<ContentType> TRASHABLE_CONTENT_TYPES = ImmutableSet.of((Object)ContentType.PAGE, (Object)ContentType.BLOG_POST, (Object)ContentType.ATTACHMENT);
    private final ContentFactory contentFactory;
    private final ContentFinderFactory contentFinderFactory;
    private final ContentTrashService trashService;
    private final ApiSupportProvider apiSupportProvider;
    private final ContentEntityManagerInternal contentEntityManager;
    private final UserChecker userChecker;
    private final LicenseService licenseService;
    private final Supplier<TouchRelationSupport> touchRelationSupportSupplier;
    private PermissionManager permissionManager;

    public ContentServiceImpl(PermissionManager permissionManager, ContentFactory contentFactory, ContentFinderFactory contentFinderFactory, ContentTrashService trashService, ApiSupportProvider apiSupportProvider, ContentEntityManagerInternal contentEntityManager, UserChecker userChecker, Supplier<TouchRelationSupport> touchRelationSupportSupplier, LicenseService licenseService) {
        this.permissionManager = permissionManager;
        this.contentFactory = contentFactory;
        this.contentFinderFactory = contentFinderFactory;
        this.trashService = trashService;
        this.apiSupportProvider = apiSupportProvider;
        this.contentEntityManager = contentEntityManager;
        this.userChecker = userChecker;
        this.touchRelationSupportSupplier = touchRelationSupportSupplier;
        this.licenseService = licenseService;
    }

    public ContentService.ContentFinder find(Expansion ... expansions) {
        return this.contentFinderFactory.createContentFinder(expansions);
    }

    private Expansions getDefaultUpdateExpansions() {
        return new Expansions(ExpansionsParser.parse((String)"body.storage,history,space,container.history,container.version,version,ancestors"));
    }

    public Content create(Content newContent) throws ServiceException {
        return this.create(newContent, this.getDefaultUpdateExpansions().toArray());
    }

    public Content create(Content newContent, Expansion ... expansions) throws ServiceException {
        this.validator().validateCreate(newContent).throwIfNotSuccessful("Could not create content with type " + String.valueOf(newContent.getType()));
        Option<Content> created = this.createUsingApiSupport(newContent, new Expansions(expansions));
        if (created.isDefined()) {
            Content createdContent = (Content)created.get();
            this.touchRelationSupportSupplier.get().handleTouchRelations(createdContent);
            return createdContent;
        }
        throw new NotImplementedServiceException("Could not create " + String.valueOf(newContent.getType()));
    }

    private Option<Content> createUsingApiSupport(Content newContent, Expansions expansions) {
        ContentTypeApiSupport apiSupport = this.apiSupportProvider.getForType(newContent.getType());
        if (!newContent.getType().equals((Object)ContentType.ATTACHMENT)) {
            ContentEntityObject newCEO = (ContentEntityObject)apiSupport.create(newContent);
            return Option.some((Object)this.buildContentWithoutChecks(newCEO, expansions));
        }
        return Option.none();
    }

    private Option<Content> updateUsingApiSupport(Content contentToUpdate, ContentConvertible ceo) {
        ContentTypeApiSupport apiSupport = this.apiSupportProvider.getForType(ceo.getContentTypeObject());
        ContentEntityObject updatedCEO = (ContentEntityObject)apiSupport.update(contentToUpdate, ceo);
        return Option.option((Object)this.contentFactory.buildFrom(updatedCEO, this.getDefaultUpdateExpansions()));
    }

    @RetryableTransaction
    public Content update(Content updatedContent) throws ServiceException {
        if (updatedContent == null) {
            throw new BadRequestException("No content supplied to update");
        }
        ContentId contentId = updatedContent.getId();
        ContentType type = updatedContent.getType();
        ContentEntityObject ceo = ContentStatus.DRAFT.equals((Object)updatedContent.getStatus()) ? this.contentEntityManager.findDraftFor(contentId.asLong()) : this.contentEntityManager.getById(contentId);
        if (ceo == null) {
            throw new NotFoundException("Could not find Content for update with id " + String.valueOf(contentId));
        }
        if (!(ceo instanceof ContentConvertible)) {
            throw new NotImplementedServiceException("This content type is not currently supported: " + String.valueOf(type));
        }
        if (ceo.isDeleted()) {
            return this.trashService.restore(updatedContent);
        }
        this.validator().validateUpdate(updatedContent, ceo).throwIfNotSuccessful(String.format("Could not update Content of type : %s with id %s", ceo.getClass(), updatedContent.getId().serialise()));
        this.touchRelationSupportSupplier.get().handleTouchRelations(updatedContent);
        Option<Content> result = this.updateUsingApiSupport(updatedContent, (ContentConvertible)ceo);
        return (Content)result.get();
    }

    @RetryableTransaction
    public void delete(Content content) throws ServiceException {
        if (content == null) {
            throw new BadRequestException("Missing content");
        }
        if (ContentStatus.DRAFT.equals((Object)content.getStatus())) {
            throw new NotImplementedServiceException("Draft deletion via the ContentService is not supported. Use the ContentDraftService instead.");
        }
        Content existingContent = (Content)this.find(new Expansion[0]).withId(content.getId()).fetch().orElseThrow(ServiceExceptionSupplier.notFound((String)String.format("Cannot delete content with id '%s': not found.", content.getId())));
        if (TRASHABLE_CONTENT_TYPES.contains((Object)existingContent.getType())) {
            this.trashService.trash(existingContent);
        } else {
            this.trashService.purge(existingContent);
        }
    }

    public ValidatorImpl validator() {
        return new ValidatorImpl();
    }

    private Content buildContentWithoutChecks(ContentEntityObject entity, Expansions expansions) {
        return this.contentFactory.buildFrom(entity, expansions);
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public class ValidatorImpl
    implements ContentService.Validator {
        public ValidationResult validateDelete(Content content) {
            if (content == null) {
                return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)"Missing content")).build();
            }
            if (content.getType() == null) {
                ContentId contentId = content.getId();
                content = (Content)ContentServiceImpl.this.find(new Expansion[0]).withId(contentId).fetchOrNull();
                if (content == null) {
                    return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)String.format("Cannot delete content with id '%s': not found", contentId))).build();
                }
            }
            if (TRASHABLE_CONTENT_TYPES.contains((Object)content.getType())) {
                return ContentServiceImpl.this.trashService.validator().validateTrash(content);
            }
            return ContentServiceImpl.this.trashService.validator().validatePurge(content);
        }

        public ValidationResult validateCreate(Content newContent) throws ServiceException {
            this.validateLicense().throwIfNotSuccessful();
            if (newContent == null) {
                return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)"Missing new content")).build();
            }
            ValidationResult result = this.validateBodyCount(newContent);
            if (!result.isValid()) {
                return result;
            }
            return this.validateCreateUsingApiSupport(newContent);
        }

        private ValidationResult validateCreateUsingApiSupport(Content newContent) {
            if (newContent.getType() == null) {
                return SimpleValidationResult.builder().authorized(true).addError("type is required to create content", new Object[0]).build();
            }
            ContentTypeApiSupport apiSupport = ContentServiceImpl.this.apiSupportProvider.getForType(newContent.getType());
            return apiSupport.validateCreate(newContent);
        }

        private ValidationResult validateUpdateUsingApiSupport(Content newContent, ContentConvertible existingEntity) {
            SimpleValidationResult.Builder builder = SimpleValidationResult.builder();
            if (!ContentServiceImpl.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)existingEntity)) {
                builder.authorized(false).addError("You do not have permission to edit this content", new Object[0]);
            } else {
                builder.authorized(true);
            }
            ContentType contentType = newContent.getType();
            if (contentType == null || !contentType.equals((Object)existingEntity.getContentTypeObject())) {
                return builder.addError(String.format("Type is required and must match existing entity type of %s, but received %s", existingEntity.getContentTypeObject(), contentType), new Object[0]).build();
            }
            ContentTypeApiSupport apiSupport = ContentServiceImpl.this.apiSupportProvider.getForType(contentType);
            return apiSupport.validateUpdate(newContent, existingEntity);
        }

        protected ValidationResult validateUpdate(Content updatedContent, ContentEntityObject currentCeo) {
            this.validateLicense().throwIfNotSuccessful();
            if (updatedContent == null) {
                throw new BadRequestException("Missing updated content.");
            }
            if (currentCeo == null) {
                throw new BadRequestException("Missing current content entity object.");
            }
            Reference updatedVersionRef = updatedContent.getVersionRef();
            if (!updatedVersionRef.isExpanded() || !updatedVersionRef.exists()) {
                throw new BadRequestException("Must supply an incremented version when updating Content. No version supplied.");
            }
            int currentVersion = currentCeo.getVersion();
            int updatedVersion = ((Version)updatedVersionRef.get()).getNumber();
            if (currentCeo.isDraft()) {
                if (updatedVersion != currentVersion) {
                    throw new ConflictException("Draft versioning is not supported. Current version is : " + currentVersion);
                }
            } else if (updatedVersion != currentVersion + 1) {
                throw new ConflictException("Version must be incremented on update. Current version is: " + currentVersion);
            }
            if (updatedContent.getPosition() < -1) {
                throw new BadRequestException("Set new page position to a positive integer, or -1 to unset.");
            }
            ValidationResult result = this.validateBodyCount(updatedContent);
            if (!result.isValid()) {
                return result;
            }
            return this.validateUpdateUsingApiSupport(updatedContent, (ContentConvertible)currentCeo);
        }

        private ValidationResult validateBodyCount(Content content) {
            int bodyCount = content.getBody().size();
            if (bodyCount > 1) {
                List bodyTypes = content.getBody().keySet().stream().map(ContentRepresentation::getRepresentation).collect(Collectors.toList());
                String message = String.format("Maximum number of permitted body entries is 1 but found %d: %s", bodyCount, String.join((CharSequence)", ", bodyTypes));
                return SimpleValidationResult.builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)message)).build();
            }
            return SimpleValidationResult.VALID;
        }

        private ValidationResult validateLicense() {
            if (ContentServiceImpl.this.licenseService.retrieve().isExpired() || ContentServiceImpl.this.userChecker != null && ContentServiceImpl.this.userChecker.hasTooManyUsers()) {
                return SimpleValidationResult.FORBIDDEN;
            }
            return SimpleValidationResult.VALID;
        }
    }
}

