/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content;

import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.service.content.CustomContentService;
import com.atlassian.confluence.content.CustomContentManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.ContentEntityManagerInternal;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CustomContentServiceImpl
implements CustomContentService {
    private final CustomContentManager customContentManager;
    private final ContentEntityManagerInternal contentEntityManager;
    private final ContentFactory contentFactory;

    public CustomContentServiceImpl(CustomContentManager customContentManager, ContentEntityManagerInternal contentEntityManager, ContentFactory contentFactory) {
        this.customContentManager = customContentManager;
        this.contentEntityManager = contentEntityManager;
        this.contentFactory = contentFactory;
    }

    public @NonNull PageResponse<Content> getChildrenOfTypeAndFilter(@NonNull ContentId parentId, String contentModuleKey, LimitedRequest limitedRequest, Expansions expansions, Depth depth, Predicate<Content> predicate) {
        ContentEntityObject parent = this.contentEntityManager.getById(parentId);
        if (parent == null) {
            return PageResponseImpl.empty((boolean)false);
        }
        PageResponse customContentEntityPageResponse = this.customContentManager.getChildrenOfTypeAndFilter(this.contentEntityManager.getById(parentId), contentModuleKey, limitedRequest, expansions, depth, (Predicate)Predicates.alwaysTrue());
        List results = customContentEntityPageResponse.getResults();
        Iterable<Content> contentList = this.contentFactory.buildFrom(results, expansions);
        List result = StreamSupport.stream(contentList.spliterator(), false).collect(Collectors.toList());
        return PageResponseImpl.filteredResponse((LimitedRequest)limitedRequest, result, predicate);
    }
}

