/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.api.impl.service.content.factory.LabelFactory;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.LabelService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.dmz.labels.LabelManagerInternal;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelPermissionEnforcer;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;
import com.atlassian.confluence.rest.v2.api.model.pagination.PaginationLimits;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.user.User;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;

public class LabelServiceImpl
implements LabelService {
    private final PaginationService paginationService;
    private final LabelManagerInternal labelManager;
    private final LabelFactory labelFactory;
    private final LabelPermissionEnforcer labelPermissionEnforcer;
    private final ApplicationConfiguration applicationConfig;
    private static final int MAX_RELATED_LABELS_TO_PROCESS_DEFAULT = 10000;
    private static final String MAX_RELATED_LABELS_TO_PROCESS_KEY = "confluence.rest.labels.related.max.to.process";
    private static final int MAX_RECENT_LABELS_TO_PROCESS_DEFAULT = 10000;
    private static final String MAX_RECENT_LABELS_TO_PROCESS_KEY = "confluence.rest.labels.recent.max.to.process";

    public LabelServiceImpl(PaginationService paginationService, LabelManagerInternal labelManager, LabelFactory labelFactory, LabelPermissionEnforcer labelPermissionEnforcer, ApplicationConfiguration applicationConfig) {
        this.paginationService = paginationService;
        this.labelManager = labelManager;
        this.labelFactory = labelFactory;
        this.labelPermissionEnforcer = labelPermissionEnforcer;
        this.applicationConfig = applicationConfig;
    }

    private int getMaxLabelsToProcess(String systemPropertyKey, int defaultValue) {
        return (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{Integer.getInteger(systemPropertyKey), Optional.ofNullable((String)this.applicationConfig.getProperty((Object)systemPropertyKey)).map(value -> {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).orElse(null), defaultValue});
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> getLabelsByDetail(PageRequest pageRequest, String labelName, String namespace, String spaceKey, String owner) {
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.labels());
        return this.paginationService.performPaginationListRequest(limitedRequest, input -> {
            PageResponse result = this.labelManager.getLabelsByDetail(input, labelName, namespace, spaceKey, owner);
            List filteredByVisibleLabels = this.labelPermissionEnforcer.filterVisibleLabels(result.getResults(), (User)AuthenticatedUserThreadLocal.get(), true);
            return PageResponseImpl.builder().addAll((Iterable)filteredByVisibleLabels).hasMore(result.hasMore()).pageRequest(pageRequest).build();
        }, this.labelEntityToModelMapper());
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> getRelatedLabels(String labelName, int maxCount) throws BadRequestException, NotFoundException {
        SimplePageRequest pageRequest = new SimplePageRequest(0, maxCount);
        return this.getRelatedLabels(labelName, (PageRequest)pageRequest);
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> getRelatedLabels(String labelName, PageRequest pageRequest) throws BadRequestException, NotFoundException {
        this.validator().validateLabelExists(labelName).throwIfNotSuccessful("Cannot get labels");
        Label label = this.labelManager.getLabel(labelName);
        if (!this.labelPermissionEnforcer.userCanViewLabel(label)) {
            return PageResponseImpl.empty((boolean)false, (PageRequest)pageRequest);
        }
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.labels());
        return this.paginationService.performPaginationListRequest(limitedRequest, input -> {
            PageResponse result = this.labelManager.getRelatedLabels(label, input);
            return this.fetchFilteredLabelsPageResponse(pageRequest, (LimitedRequest)input, (PageResponse<Label>)result, MAX_RELATED_LABELS_TO_PROCESS_KEY, 10000);
        }, this.labelEntityToModelMapper());
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> getRecentlyUsedLabels(PageRequest pageRequest) {
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.labels());
        return this.paginationService.performPaginationListRequest(limitedRequest, input -> {
            PageResponse result = this.labelManager.getRecentlyUsedLabels(input);
            return this.fetchFilteredLabelsPageResponse(pageRequest, (LimitedRequest)input, (PageResponse<Label>)result, MAX_RECENT_LABELS_TO_PROCESS_KEY, 10000);
        }, this.labelEntityToModelMapper());
    }

    private PageResponse<Label> fetchFilteredLabelsPageResponse(PageRequest pageRequest, LimitedRequest input, PageResponse<Label> result, String maxRecentLabelsToProcessKey, int maxRecentLabelsToProcessDefault) {
        List authorizedLabels = this.labelPermissionEnforcer.filterAuthorizedLabels(result.getResults());
        return PageResponseImpl.builder().addAll((Iterable)authorizedLabels).hasMore(input.getStart() + input.getLimit() < this.getMaxLabelsToProcess(maxRecentLabelsToProcessKey, maxRecentLabelsToProcessDefault) && result.hasMore()).pageRequest(pageRequest).build();
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> getMostPopularLabels(PageRequest pageRequest) {
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.labels());
        PageResponse result = this.labelManager.getMostPopularLabels(limitedRequest);
        List<com.atlassian.confluence.api.model.content.Label> labels = result.getResults().stream().map(LabelSearchResult::getLabel).map(label -> this.labelFactory.buildFrom((Label)label, (Expansions)null)).toList();
        return PageResponseImpl.from(labels, (boolean)result.hasMore()).pageRequest(pageRequest).build();
    }

    public LabelService.Validator validator() {
        return new ValidatorImpl();
    }

    private Function<Iterable<Label>, Iterable<com.atlassian.confluence.api.model.content.Label>> labelEntityToModelMapper() {
        return labels -> this.labelFactory.buildFrom((Iterable)labels, null);
    }

    public class ValidatorImpl
    implements LabelService.Validator {
        public ValidationResult validateLabelExists(String labelName) {
            if (!LabelUtil.isValidLabelName((String)labelName)) {
                return new SimpleValidationResult.Builder().authorized(true).addError(String.format("The label name of \"%s\" is invalid.", labelName), new Object[0]).withExceptionSupplier(ServiceExceptionSupplier.badRequestExceptionSupplier()).build();
            }
            Label label = LabelServiceImpl.this.labelManager.getLabel(labelName);
            if (label == null) {
                return new SimpleValidationResult.Builder().authorized(true).addError(String.format("Unable to find a label with the name of \"%s\".", labelName), new Object[0]).withExceptionSupplier(ServiceExceptionSupplier.notFoundExceptionSupplier()).build();
            }
            return SimpleValidationResult.VALID;
        }
    }
}

